(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    186399,       3950]
NotebookOptionsPosition[    135506,       3040]
NotebookOutlinePosition[    181767,       3891]
CellTagsIndexPosition[    181724,       3888]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Mechanical", " ", 
    RowBox[{"stability", ".", "nb"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Stiffness_tensor", ":", " ", 
      RowBox[{"NiAl_oriented", "_", " ", "X"}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"[", "100", "]"}], " ", "Y"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"[", "010", "]"}], " ", "Z"}], "=", 
       RowBox[{"[", "001", "]"}]}]}]}], "*)"}]}]}]], "Input",
 CellChangeTimes->{
  3.8304206480295973`*^9, {3.926817093067008*^9, 3.9268171031271243`*^9}, 
   3.936582427177846*^9, 3.941434324222528*^9, {3.941440825489588*^9, 
   3.9414408361289406`*^9}, {3.9414488384932256`*^9, 3.9414488397201004`*^9}, 
   3.9414489692019444`*^9, {3.9414493970969954`*^9, 3.9414494006660347`*^9}, {
   3.9414499468040323`*^9, 3.9414499504711885`*^9}, {3.9414500335599623`*^9, 
   3.941450042546749*^9}, 3.9414502382440577`*^9, {3.9414529828195467`*^9, 
   3.9414529846257324`*^9}},
 CellLabel->
  "In[2859]:=",ExpressionUUID->"c220cb0e-a916-48ce-a81c-0205de56f38c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"C11all", "=", "190.86794377"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C22all", "=", "190.86794377"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C33all", "=", "190.86794377"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C12all", "=", "142.90799310"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C13all", "=", "142.90799310"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C23all", "=", "142.90799310"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C44all", "=", "121.48571335"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C55all", "=", "121.48571335"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C66all", "=", "121.48571335"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C14all", "=", "0.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C15all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C16all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C24all", "=", "0.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C25all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C26all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C34all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C35all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C36all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C45all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C46all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"C56all", "=", "0.0"}], 
   RowBox[{"(*", "GPa", " ", "*)"}], " ", ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Stiffness_tensor", "_in", "_orthonormal", "_notation"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ST", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"C11all", "C12all", "C13all", 
       RowBox[{
        SqrtBox["2"], "*", "C14all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C15all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C16all"}]},
      {"C12all", "C22all", "C23all", 
       RowBox[{
        SqrtBox["2"], "*", "C24all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C25all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C26all"}]},
      {"C13all", "C23all", "C33all", 
       RowBox[{
        SqrtBox["2"], "*", "C34all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C35all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C36all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C14all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C24all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C34all"}], 
       RowBox[{"2", "*", "C44all"}], 
       RowBox[{"2", "*", "C45all"}], 
       RowBox[{"2", "*", "C46all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C15all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C25all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C35all"}], 
       RowBox[{"2", "*", "C45all"}], 
       RowBox[{"2", "*", "C55all"}], 
       RowBox[{"2", "*", "C56all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C16all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C26all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C36all"}], 
       RowBox[{"2", "*", "C46all"}], 
       RowBox[{"2", "*", "C56all"}], 
       RowBox[{"2", "*", "C66all"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ST", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"TeXForm", "[", "ST", "]"}], "*)"}], " ", "\[IndentingNewLine]", 
  RowBox[{"(*", "Kelvin_moduli", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"EST", "=", 
  RowBox[{"Eigenvalues", "[", "ST", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"EST", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "/", 
    RowBox[{"EST", "[", 
     RowBox[{"[", "6", "]"}], "]"}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.8304206981954813`*^9, 3.8304207212935977`*^9}, {
   3.830421287798919*^9, 3.830421309895815*^9}, {3.8304213408394103`*^9, 
   3.8304214316395545`*^9}, {3.8304214834109364`*^9, 3.8304214926205072`*^9}, 
   3.8304219600715013`*^9, {3.8304232838226953`*^9, 3.830423294812406*^9}, {
   3.830423393877207*^9, 3.830423396444199*^9}, {3.830427512623121*^9, 
   3.8304275194899683`*^9}, {3.8304275505542936`*^9, 3.830427558748024*^9}, 
   3.830427620084891*^9, 3.8304281128519278`*^9, {3.8304282648268986`*^9, 
   3.8304283144345417`*^9}, 3.8304284687672176`*^9, {3.830428656603857*^9, 
   3.830428660096822*^9}, {3.830428850263464*^9, 3.830428853472473*^9}, {
   3.8304288837536297`*^9, 3.8304288873294115`*^9}, 3.8304312734597015`*^9, 
   3.8304313043416533`*^9, {3.8304388249893174`*^9, 3.830438828097963*^9}, {
   3.8304389017166986`*^9, 3.8304389045017195`*^9}, 3.8304394785103045`*^9, {
   3.875329295820007*^9, 3.875329324796239*^9}, {3.926817279242573*^9, 
   3.926817288439085*^9}, {3.9365824770783787`*^9, 3.9365825090989237`*^9}, {
   3.941432827116433*^9, 3.9414329696733403`*^9}, 3.9414345197046623`*^9, {
   3.9414346525181284`*^9, 3.9414346665829835`*^9}, 3.941434748322903*^9, {
   3.941434957014183*^9, 3.941434958287388*^9}, 3.941441073325719*^9, 
   3.9414489313711734`*^9, {3.94144942957152*^9, 3.9414495148327985`*^9}, {
   3.941449718753381*^9, 3.941449722600072*^9}, {3.94145005343366*^9, 
   3.9414500565732927`*^9}, {3.941450243239768*^9, 3.941450337001952*^9}},
 CellLabel->
  "In[2860]:=",ExpressionUUID->"3f3f6604-c04a-4043-b945-d6f8f4d99e53"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"190.86794377`", "142.9079931`", "142.9079931`", "0.`", "0.`", "0.`"},
     {"142.9079931`", "190.86794377`", "142.9079931`", "0.`", "0.`", "0.`"},
     {"142.9079931`", "142.9079931`", "190.86794377`", "0.`", "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "242.9714267`", "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "242.9714267`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "0.`", "242.9714267`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.830421433662044*^9, 3.830421493925691*^9, 3.8304216463205385`*^9, 
   3.830421920264182*^9, 3.8304219629290614`*^9, 3.830423358405199*^9, 
   3.830423399188191*^9, 3.83042350823096*^9, 3.8304237369407825`*^9, 
   3.8304237701213226`*^9, 3.8304238153180184`*^9, 3.830423868853198*^9, {
   3.830423933131401*^9, 3.8304239699407244`*^9}, 3.830424001360603*^9, 
   3.8304240444930706`*^9, {3.830424115174428*^9, 3.8304241584981027`*^9}, {
   3.8304242092121267`*^9, 3.830424233111042*^9}, 3.830424273816826*^9, {
   3.8304243652727766`*^9, 3.830424403287531*^9}, {3.8304246387678585`*^9, 
   3.830424657167798*^9}, {3.8304247374518156`*^9, 3.830424751593486*^9}, 
   3.830424788254568*^9, 3.8304248505376053`*^9, {3.83042488215001*^9, 
   3.8304249103077035`*^9}, 3.8304250177990527`*^9, {3.830425243300912*^9, 
   3.830425256143058*^9}, 3.8304253412683873`*^9, 3.8304255478506994`*^9, 
   3.830425612380595*^9, 3.8304256640361853`*^9, 3.830425832601144*^9, 
   3.830425892065365*^9, 3.8304267069354773`*^9, 3.830426943757165*^9, 
   3.830426976940725*^9, {3.8304270182214675`*^9, 3.830427047429426*^9}, 
   3.830427085199916*^9, 3.830427564499192*^9, 3.8304276230450544`*^9, 
   3.830427683647817*^9, {3.8304278803566895`*^9, 3.8304278975794253`*^9}, {
   3.8304280855678806`*^9, 3.8304281849492645`*^9}, {3.830428233109215*^9, 
   3.830428246818979*^9}, 3.8304283404582076`*^9, {3.8304283861808496`*^9, 
   3.8304283970014668`*^9}, {3.830428428166345*^9, 3.8304284720946035`*^9}, 
   3.8304286624402695`*^9, 3.830428696608026*^9, 3.8304287343770523`*^9, 
   3.83042885626254*^9, 3.8304288897662506`*^9, 3.830431177888773*^9, 
   3.830431210337224*^9, {3.830431249730981*^9, 3.8304312770836935`*^9}, 
   3.830431309043419*^9, 3.830431635848398*^9, 3.8304323508998737`*^9, {
   3.830432977934039*^9, 3.8304330252048793`*^9}, {3.830433092596711*^9, 
   3.830433116607608*^9}, 3.8304331688042316`*^9, 3.8304332078925858`*^9, 
   3.8304382257388625`*^9, 3.830438611730996*^9, 3.830438830503637*^9, {
   3.8304388851257715`*^9, 3.830438907136668*^9}, 3.830439481254997*^9, 
   3.8752617060320125`*^9, 3.8752623409778757`*^9, 3.8752625209782505`*^9, 
   3.875262769406554*^9, 3.875262896080858*^9, 3.8752632372048445`*^9, 
   3.87532701891116*^9, 3.8753272841903725`*^9, 3.8753273910964813`*^9, {
   3.8753275721837716`*^9, 3.8753275920429897`*^9}, {3.8753277415030785`*^9, 
   3.8753277556320734`*^9}, 3.8753277911710224`*^9, 3.8753280008471904`*^9, 
   3.875328296808892*^9, {3.8753283349776173`*^9, 3.8753283536101437`*^9}, 
   3.8753292528601146`*^9, {3.8753292984443827`*^9, 3.875329327514349*^9}, {
   3.875329393810013*^9, 3.8753294221163936`*^9}, {3.8753294612703824`*^9, 
   3.8753294757685337`*^9}, 3.8753295096263905`*^9, {3.875329577617995*^9, 
   3.8753295953113585`*^9}, 3.875329640826494*^9, 3.8753298296107264`*^9, 
   3.8753298618271074`*^9, 3.875329928233461*^9, 3.926817294500181*^9, 
   3.9365827163683653`*^9, 3.936582864114354*^9, 3.936583012695463*^9, 
   3.941351075966641*^9, {3.941432976120723*^9, 3.941432999000828*^9}, 
   3.941433089462461*^9, 3.941433156271005*^9, 3.9414332453147273`*^9, 
   3.9414335349445534`*^9, 3.9414342943182945`*^9, {3.9414345050129313`*^9, 
   3.9414345340184183`*^9}, 3.941434724107806*^9, {3.9414348874819055`*^9, 
   3.9414349038309546`*^9}, 3.941434970437791*^9, 3.941437871306075*^9, 
   3.941438158594805*^9, 3.941439365436298*^9, 3.941439400630951*^9, 
   3.941439895521677*^9, {3.94143993418989*^9, 3.941439984855011*^9}, 
   3.9414400587851553`*^9, 3.94144019687331*^9, 3.9414405581253405`*^9, 
   3.9414406243851147`*^9, 3.9414407432449226`*^9, 3.9414408437789063`*^9, {
   3.9414410275133677`*^9, 3.941441051903716*^9}, 3.9414411049029245`*^9, 
   3.941441254653037*^9, 3.9414491884575186`*^9, 3.9414496886463146`*^9, 
   3.9414499542315445`*^9, 3.941450109516746*^9, 3.9414508781079564`*^9, 
   3.9414510072022295`*^9, 3.9414514130894537`*^9, 3.9414521063689394`*^9, 
   3.9414521710893593`*^9, 3.9414523968679*^9, 3.941452503044095*^9, 
   3.9414527613164797`*^9, 3.9414528221323385`*^9, 3.9414530916624346`*^9, 
   3.941453443701753*^9},
 CellLabel->
  "Out[2882]//MatrixForm=",ExpressionUUID->"0ccdd3b3-57b0-4718-bc86-\
c8cb549455e4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "476.6839299700001`", ",", "242.9714267`", ",", "242.9714267`", ",", 
   "242.9714267`", ",", "47.95995067000007`", ",", "47.959950670000026`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.830421433662044*^9, 3.830421493925691*^9, 3.8304216463205385`*^9, 
   3.830421920264182*^9, 3.8304219629290614`*^9, 3.830423358405199*^9, 
   3.830423399188191*^9, 3.83042350823096*^9, 3.8304237369407825`*^9, 
   3.8304237701213226`*^9, 3.8304238153180184`*^9, 3.830423868853198*^9, {
   3.830423933131401*^9, 3.8304239699407244`*^9}, 3.830424001360603*^9, 
   3.8304240444930706`*^9, {3.830424115174428*^9, 3.8304241584981027`*^9}, {
   3.8304242092121267`*^9, 3.830424233111042*^9}, 3.830424273816826*^9, {
   3.8304243652727766`*^9, 3.830424403287531*^9}, {3.8304246387678585`*^9, 
   3.830424657167798*^9}, {3.8304247374518156`*^9, 3.830424751593486*^9}, 
   3.830424788254568*^9, 3.8304248505376053`*^9, {3.83042488215001*^9, 
   3.8304249103077035`*^9}, 3.8304250177990527`*^9, {3.830425243300912*^9, 
   3.830425256143058*^9}, 3.8304253412683873`*^9, 3.8304255478506994`*^9, 
   3.830425612380595*^9, 3.8304256640361853`*^9, 3.830425832601144*^9, 
   3.830425892065365*^9, 3.8304267069354773`*^9, 3.830426943757165*^9, 
   3.830426976940725*^9, {3.8304270182214675`*^9, 3.830427047429426*^9}, 
   3.830427085199916*^9, 3.830427564499192*^9, 3.8304276230450544`*^9, 
   3.830427683647817*^9, {3.8304278803566895`*^9, 3.8304278975794253`*^9}, {
   3.8304280855678806`*^9, 3.8304281849492645`*^9}, {3.830428233109215*^9, 
   3.830428246818979*^9}, 3.8304283404582076`*^9, {3.8304283861808496`*^9, 
   3.8304283970014668`*^9}, {3.830428428166345*^9, 3.8304284720946035`*^9}, 
   3.8304286624402695`*^9, 3.830428696608026*^9, 3.8304287343770523`*^9, 
   3.83042885626254*^9, 3.8304288897662506`*^9, 3.830431177888773*^9, 
   3.830431210337224*^9, {3.830431249730981*^9, 3.8304312770836935`*^9}, 
   3.830431309043419*^9, 3.830431635848398*^9, 3.8304323508998737`*^9, {
   3.830432977934039*^9, 3.8304330252048793`*^9}, {3.830433092596711*^9, 
   3.830433116607608*^9}, 3.8304331688042316`*^9, 3.8304332078925858`*^9, 
   3.8304382257388625`*^9, 3.830438611730996*^9, 3.830438830503637*^9, {
   3.8304388851257715`*^9, 3.830438907136668*^9}, 3.830439481254997*^9, 
   3.8752617060320125`*^9, 3.8752623409778757`*^9, 3.8752625209782505`*^9, 
   3.875262769406554*^9, 3.875262896080858*^9, 3.8752632372048445`*^9, 
   3.87532701891116*^9, 3.8753272841903725`*^9, 3.8753273910964813`*^9, {
   3.8753275721837716`*^9, 3.8753275920429897`*^9}, {3.8753277415030785`*^9, 
   3.8753277556320734`*^9}, 3.8753277911710224`*^9, 3.8753280008471904`*^9, 
   3.875328296808892*^9, {3.8753283349776173`*^9, 3.8753283536101437`*^9}, 
   3.8753292528601146`*^9, {3.8753292984443827`*^9, 3.875329327514349*^9}, {
   3.875329393810013*^9, 3.8753294221163936`*^9}, {3.8753294612703824`*^9, 
   3.8753294757685337`*^9}, 3.8753295096263905`*^9, {3.875329577617995*^9, 
   3.8753295953113585`*^9}, 3.875329640826494*^9, 3.8753298296107264`*^9, 
   3.8753298618271074`*^9, 3.875329928233461*^9, 3.926817294500181*^9, 
   3.9365827163683653`*^9, 3.936582864114354*^9, 3.936583012695463*^9, 
   3.941351075966641*^9, {3.941432976120723*^9, 3.941432999000828*^9}, 
   3.941433089462461*^9, 3.941433156271005*^9, 3.9414332453147273`*^9, 
   3.9414335349445534`*^9, 3.9414342943182945`*^9, {3.9414345050129313`*^9, 
   3.9414345340184183`*^9}, 3.941434724107806*^9, {3.9414348874819055`*^9, 
   3.9414349038309546`*^9}, 3.941434970437791*^9, 3.941437871306075*^9, 
   3.941438158594805*^9, 3.941439365436298*^9, 3.941439400630951*^9, 
   3.941439895521677*^9, {3.94143993418989*^9, 3.941439984855011*^9}, 
   3.9414400587851553`*^9, 3.94144019687331*^9, 3.9414405581253405`*^9, 
   3.9414406243851147`*^9, 3.9414407432449226`*^9, 3.9414408437789063`*^9, {
   3.9414410275133677`*^9, 3.941441051903716*^9}, 3.9414411049029245`*^9, 
   3.941441254653037*^9, 3.9414491884575186`*^9, 3.9414496886463146`*^9, 
   3.9414499542315445`*^9, 3.941450109516746*^9, 3.9414508781079564`*^9, 
   3.9414510072022295`*^9, 3.9414514130894537`*^9, 3.9414521063689394`*^9, 
   3.9414521710893593`*^9, 3.9414523968679*^9, 3.941452503044095*^9, 
   3.9414527613164797`*^9, 3.9414528221323385`*^9, 3.9414530916624346`*^9, 
   3.9414534437077627`*^9},
 CellLabel->
  "Out[2883]=",ExpressionUUID->"95db776d-5f7f-4a69-8656-713726ba7581"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Stiffness_tensor", ":", " ", 
    RowBox[{"NiAl_oriented", "_X"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"[", "110", "]"}], " ", "Y"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"[", 
       RowBox[{"-", "110"}], "]"}], " ", "Z"}], "=", 
     RowBox[{"[", "001", "]"}]}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.9268178265577145`*^9, 3.9268178369182425`*^9}, 
   3.941434319949896*^9, {3.941449857212184*^9, 3.941449886865281*^9}, 
   3.9414499409523506`*^9, {3.9414503448832154`*^9, 3.941450355934088*^9}},
 CellLabel->
  "In[2884]:=",ExpressionUUID->"86acad93-7342-4ded-b093-b5264b074c2f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"C11all", "=", "288.37368179"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C22all", "=", "288.37368179"}], ";"}], 
  "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C33all", "=", "190.86794377"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C12all", "=", "45.402255088"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C13all", "=", "142.90799310"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C23all", "=", "142.90799310"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C44all", "=", "121.48571335"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C55all", "=", "121.48571335"}], ";"}], 
  "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C66all", "=", "23.979975335"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C14all", "=", "0.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C15all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C16all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C24all", "=", "0.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C25all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C26all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C34all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C35all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C36all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C45all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C46all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"C56all", "=", "0.0"}], 
   RowBox[{"(*", "GPa", " ", "*)"}], " ", ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Stiffness_tensor", "_in", "_", "orthonormal", "_", "notation"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DST", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"C11all", "C12all", "C13all", 
       RowBox[{
        SqrtBox["2"], "*", "C14all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C15all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C16all"}]},
      {"C12all", "C22all", "C23all", 
       RowBox[{
        SqrtBox["2"], "*", "C24all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C25all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C26all"}]},
      {"C13all", "C23all", "C33all", 
       RowBox[{
        SqrtBox["2"], "*", "C34all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C35all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C36all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C14all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C24all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C34all"}], 
       RowBox[{"2", "*", "C44all"}], 
       RowBox[{"2", "*", "C45all"}], 
       RowBox[{"2", "*", "C46all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C15all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C25all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C35all"}], 
       RowBox[{"2", "*", "C45all"}], 
       RowBox[{"2", "*", "C55all"}], 
       RowBox[{"2", "*", "C56all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C16all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C26all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C36all"}], 
       RowBox[{"2", "*", "C46all"}], 
       RowBox[{"2", "*", "C56all"}], 
       RowBox[{"2", "*", "C66all"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DST", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"TeXForm", "[", "ST", "]"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Kelvin_moduli", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"EST", "=", 
  RowBox[{"Eigenvalues", "[", "ST", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"EST", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "/", 
    RowBox[{"EST", "[", 
     RowBox[{"[", "6", "]"}], "]"}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.8304206981954813`*^9, 3.8304207212935977`*^9}, {
   3.830421287798919*^9, 3.830421309895815*^9}, {3.8304213408394103`*^9, 
   3.8304214316395545`*^9}, {3.8304214834109364`*^9, 3.8304214926205072`*^9}, 
   3.8304219600715013`*^9, {3.8304232838226953`*^9, 3.830423294812406*^9}, {
   3.830423393877207*^9, 3.830423396444199*^9}, {3.830427512623121*^9, 
   3.8304275194899683`*^9}, {3.8304275505542936`*^9, 3.830427558748024*^9}, 
   3.830427620084891*^9, 3.8304281128519278`*^9, {3.8304282648268986`*^9, 
   3.8304283144345417`*^9}, 3.8304284687672176`*^9, {3.830428656603857*^9, 
   3.830428660096822*^9}, {3.830428850263464*^9, 3.830428853472473*^9}, {
   3.8304288837536297`*^9, 3.8304288873294115`*^9}, 3.8304312734597015`*^9, 
   3.8304313043416533`*^9, {3.8304388249893174`*^9, 3.830438828097963*^9}, {
   3.8304389017166986`*^9, 3.8304389045017195`*^9}, 3.8304394785103045`*^9, {
   3.875329295820007*^9, 3.875329324796239*^9}, {3.926817279242573*^9, 
   3.926817288439085*^9}, {3.936582610426938*^9, 3.936582639562281*^9}, {
   3.9414331761312714`*^9, 3.941433220673414*^9}, 3.9414334466500683`*^9, {
   3.941433866058505*^9, 3.941433947093191*^9}, {3.9414339812994595`*^9, 
   3.9414340003047132`*^9}, {3.9414341300835533`*^9, 3.9414342826870146`*^9}, 
   3.9414345291440372`*^9, {3.9414347633422403`*^9, 3.9414348450782223`*^9}, {
   3.941434900631068*^9, 3.941434946494043*^9}, {3.941449036803279*^9, 
   3.9414490438035*^9}, {3.941449526753763*^9, 3.9414495368244114`*^9}, {
   3.9414503639074807`*^9, 3.941450364636203*^9}, 3.9414505151912994`*^9},
 CellLabel->
  "In[2885]:=",ExpressionUUID->"90a9901a-e691-4da1-ae7b-2b7fd8655dba"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"288.37368179`", "45.402255088`", "142.9079931`", "0.`", "0.`", "0.`"},
     {"45.402255088`", "288.37368179`", "142.9079931`", "0.`", "0.`", "0.`"},
     {"142.9079931`", "142.9079931`", "190.86794377`", "0.`", "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "242.9714267`", "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "242.9714267`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "0.`", "47.95995067`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9365827170083237`*^9, 3.9365828648288746`*^9, 3.9365830134250603`*^9, 
   3.9413510766741624`*^9, {3.9414329777596936`*^9, 3.941432999891926*^9}, 
   3.9414330895911627`*^9, 3.941433156314889*^9, 3.9414332453745666`*^9, 
   3.941433534992426*^9, 3.9414342943617945`*^9, {3.941434505048345*^9, 
   3.9414345340722756`*^9}, 3.9414347241646714`*^9, {3.9414348875437403`*^9, 
   3.941434903892789*^9}, 3.941434970505609*^9, 3.9414378713554697`*^9, 
   3.941438158647007*^9, 3.9414393654988976`*^9, 3.94143940075984*^9, 
   3.9414398955849667`*^9, {3.941439934243828*^9, 3.9414399849115667`*^9}, 
   3.941440058843953*^9, 3.941440196934097*^9, 3.941440558181946*^9, 
   3.9414406244443593`*^9, 3.941440743299346*^9, 3.941440843831914*^9, {
   3.941441027568097*^9, 3.9414410519565287`*^9}, 3.9414411049638057`*^9, 
   3.9414412547342305`*^9, 3.941449188526147*^9, 3.9414496886890163`*^9, 
   3.9414499542729945`*^9, 3.9414501095625916`*^9, 3.9414508781468496`*^9, 
   3.9414510072500696`*^9, 3.941451413125439*^9, 3.941452106406871*^9, 
   3.94145217112726*^9, 3.9414523969097595`*^9, 3.941452503081027*^9, 
   3.9414527613593645`*^9, 3.9414528221792097`*^9, 3.9414530917053223`*^9, 
   3.9414534437871003`*^9},
 CellLabel->
  "Out[2907]//MatrixForm=",ExpressionUUID->"b6811655-a4ab-44bc-b190-\
616a0ef1d32f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "476.6839299700001`", ",", "242.9714267`", ",", "242.9714267`", ",", 
   "242.9714267`", ",", "47.95995067000007`", ",", "47.959950670000026`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.9365827170083237`*^9, 3.9365828648288746`*^9, 3.9365830134250603`*^9, 
   3.9413510766741624`*^9, {3.9414329777596936`*^9, 3.941432999891926*^9}, 
   3.9414330895911627`*^9, 3.941433156314889*^9, 3.9414332453745666`*^9, 
   3.941433534992426*^9, 3.9414342943617945`*^9, {3.941434505048345*^9, 
   3.9414345340722756`*^9}, 3.9414347241646714`*^9, {3.9414348875437403`*^9, 
   3.941434903892789*^9}, 3.941434970505609*^9, 3.9414378713554697`*^9, 
   3.941438158647007*^9, 3.9414393654988976`*^9, 3.94143940075984*^9, 
   3.9414398955849667`*^9, {3.941439934243828*^9, 3.9414399849115667`*^9}, 
   3.941440058843953*^9, 3.941440196934097*^9, 3.941440558181946*^9, 
   3.9414406244443593`*^9, 3.941440743299346*^9, 3.941440843831914*^9, {
   3.941441027568097*^9, 3.9414410519565287`*^9}, 3.9414411049638057`*^9, 
   3.9414412547342305`*^9, 3.941449188526147*^9, 3.9414496886890163`*^9, 
   3.9414499542729945`*^9, 3.9414501095625916`*^9, 3.9414508781468496`*^9, 
   3.9414510072500696`*^9, 3.941451413125439*^9, 3.941452106406871*^9, 
   3.94145217112726*^9, 3.9414523969097595`*^9, 3.941452503081027*^9, 
   3.9414527613593645`*^9, 3.9414528221792097`*^9, 3.9414530917053223`*^9, 
   3.9414534438003225`*^9},
 CellLabel->
  "Out[2908]=",ExpressionUUID->"43ab9b0c-373c-417b-865e-962b5e2211f9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Stiffness_tensor", ":", " ", 
    RowBox[{"NiAl_oriented", "_X"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"[", "111", "]"}], " ", "Y"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"[", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "12"}], "]"}], " ", "Z"}], "=", 
     RowBox[{"[", 
      RowBox[{"1", "-", "10"}], "]"}]}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.9268178265577145`*^9, 3.9268178369182425`*^9}, 
   3.941434319949896*^9, 3.9414377723281384`*^9, {3.9414503701501155`*^9, 
   3.941450396444741*^9}},
 CellLabel->
  "In[2909]:=",ExpressionUUID->"9573ddf7-1386-43f0-aca7-5b2b1b7c4af3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"C11all", "=", "320.87559442"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C22all", "=", "288.37368177"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C33all", "=", "288.37368177"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C12all", "=", "77.904167747"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C13all", "=", "77.904167747"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C23all", "=", "110.40608041"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C44all", "=", "88.983800684"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C55all", "=", "56.481888013"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C66all", "=", "56.481888013"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C14all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C15all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C16all", "=", "0.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C24all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C25all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"C26all", "=", 
    RowBox[{"-", "45.96464569"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C34all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C35all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"C36all", "=", "45.964645690"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C45all", "=", "45.964645690"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C46all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"C56all", "=", "0.0"}], 
   RowBox[{"(*", "GPa", " ", "*)"}], " ", ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Stiffness_tensor", "_in", "_", "orthonormal", "_", "notation"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DST", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"C11all", "C12all", "C13all", 
       RowBox[{
        SqrtBox["2"], "*", "C14all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C15all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C16all"}]},
      {"C12all", "C22all", "C23all", 
       RowBox[{
        SqrtBox["2"], "*", "C24all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C25all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C26all"}]},
      {"C13all", "C23all", "C33all", 
       RowBox[{
        SqrtBox["2"], "*", "C34all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C35all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C36all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C14all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C24all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C34all"}], 
       RowBox[{"2", "*", "C44all"}], 
       RowBox[{"2", "*", "C45all"}], 
       RowBox[{"2", "*", "C46all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C15all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C25all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C35all"}], 
       RowBox[{"2", "*", "C45all"}], 
       RowBox[{"2", "*", "C55all"}], 
       RowBox[{"2", "*", "C56all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C16all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C26all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C36all"}], 
       RowBox[{"2", "*", "C46all"}], 
       RowBox[{"2", "*", "C56all"}], 
       RowBox[{"2", "*", "C66all"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DST", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"TeXForm", "[", "ST", "]"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Kelvin_moduli", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"EST", "=", 
  RowBox[{"Eigenvalues", "[", "ST", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"EST", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "/", 
    RowBox[{"EST", "[", 
     RowBox[{"[", "6", "]"}], "]"}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.9414378263695645`*^9, 3.941437864430026*^9}, {
   3.9414379718847218`*^9, 3.9414380723280168`*^9}, {3.941438140229308*^9, 
   3.941438152187189*^9}, {3.941449051332981*^9, 3.9414490570023093`*^9}, {
   3.9414495442158217`*^9, 3.9414495548170147`*^9}, {3.941450404100087*^9, 
   3.9414504048150187`*^9}, 3.9414505075511007`*^9, 3.941450554486808*^9},
 CellLabel->
  "In[2910]:=",ExpressionUUID->"9605dcd7-3e19-4471-af22-63e821cb8e62"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"320.87559442`", "77.904167747`", "77.904167747`", "0.`", "0.`", "0.`"},
     {"77.904167747`", "288.37368177`", "110.40608041`", "0.`", "0.`", 
      RowBox[{"-", "65.00382532447203`"}]},
     {"77.904167747`", "110.40608041`", "288.37368177`", "0.`", "0.`", 
      "65.00382532447203`"},
     {"0.`", "0.`", "0.`", "177.967601368`", "91.92929138`", "0.`"},
     {"0.`", "0.`", "0.`", "91.92929138`", "112.963776026`", "0.`"},
     {"0.`", 
      RowBox[{"-", "65.00382532447203`"}], "65.00382532447203`", "0.`", "0.`",
       "112.963776026`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.941437871402317*^9, 3.9414381586980977`*^9, 3.941439365560299*^9, 
   3.9414394008228607`*^9, 3.941439895649494*^9, {3.9414399343014565`*^9, 
   3.941439984970113*^9}, 3.941440058901903*^9, 3.9414401969944963`*^9, 
   3.9414405582386103`*^9, 3.9414406245042267`*^9, 3.9414407433556194`*^9, 
   3.9414408438888397`*^9, {3.941441027621961*^9, 3.941441052011324*^9}, 
   3.941441105018216*^9, 3.9414412547895026`*^9, 3.9414491885686903`*^9, 
   3.9414496887333727`*^9, 3.941449954312879*^9, 3.941450109600518*^9, 
   3.9414508781887393`*^9, 3.941451007290228*^9, 3.941451413164336*^9, 
   3.941452106447883*^9, 3.9414521711651554`*^9, 3.941452396951675*^9, 
   3.941452503118922*^9, 3.941452761396734*^9, 3.9414528222190995`*^9, 
   3.9414530917457595`*^9, 3.9414534438325944`*^9},
 CellLabel->
  "Out[2932]//MatrixForm=",ExpressionUUID->"ade0421b-457f-4a41-8b80-\
9ad8bcfbe08d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "476.6839299700001`", ",", "242.9714267`", ",", "242.9714267`", ",", 
   "242.9714267`", ",", "47.95995067000007`", ",", "47.959950670000026`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.941437871402317*^9, 3.9414381586980977`*^9, 3.941439365560299*^9, 
   3.9414394008228607`*^9, 3.941439895649494*^9, {3.9414399343014565`*^9, 
   3.941439984970113*^9}, 3.941440058901903*^9, 3.9414401969944963`*^9, 
   3.9414405582386103`*^9, 3.9414406245042267`*^9, 3.9414407433556194`*^9, 
   3.9414408438888397`*^9, {3.941441027621961*^9, 3.941441052011324*^9}, 
   3.941441105018216*^9, 3.9414412547895026`*^9, 3.9414491885686903`*^9, 
   3.9414496887333727`*^9, 3.941449954312879*^9, 3.941450109600518*^9, 
   3.9414508781887393`*^9, 3.941451007290228*^9, 3.941451413164336*^9, 
   3.941452106447883*^9, 3.9414521711651554`*^9, 3.941452396951675*^9, 
   3.941452503118922*^9, 3.941452761396734*^9, 3.9414528222190995`*^9, 
   3.9414530917457595`*^9, 3.941453443839599*^9},
 CellLabel->
  "Out[2933]=",ExpressionUUID->"01642206-1945-4735-85b1-20c2353be544"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Stiffness_tensor", ":", " ", 
    RowBox[{"NiAl_oriented", "_X"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"[", "100", "]"}], " ", "Y"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"[", "010", "]"}], " ", "Z"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"[", "001", "]"}], "_biaxial", "_strain", "_C", "_singular", 
       "_for", "_\[Alpha]"}], "=", "1.15365"}]}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.9339149966603627`*^9, 3.933915000663592*^9}, 
   3.933918117210417*^9, 3.9414343414141855`*^9, {3.9414384798701067`*^9, 
   3.9414384814056315`*^9}, {3.941438526339411*^9, 3.941438562896509*^9}, {
   3.9414504098385696`*^9, 3.941450420485009*^9}, {3.941450620981702*^9, 
   3.941450642508697*^9}, {3.9414530434483085`*^9, 3.941453045023775*^9}},
 CellLabel->
  "In[2934]:=",ExpressionUUID->"0008b473-448e-4877-9423-f6937d4c7ed1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"C11all", "=", "12.351"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C22all", "=", "12.351"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C33all", "=", "54.415"}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C12all", "=", "12.375"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C13all", "=", "5.225"}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C23all", "=", "5.225"}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C44all", "=", "30.863"}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C55all", "=", "30.863"}], ";"}], "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C66all", "=", "42.361"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C14all", "=", "0.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C15all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C16all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C24all", "=", "0.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C25all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C26all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C34all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C35all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C36all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C45all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C46all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C56all", "=", "0.0"}], 
  RowBox[{"(*", "GPa", " ", "*)"}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S11", "=", 
   RowBox[{"-", "27.046"}]}], 
  RowBox[{"(*", "GPa", " ", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"S22", "=", 
   RowBox[{"-", "27.046"}]}], 
  RowBox[{"(*", "GPa", " ", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"S33", "=", 
   RowBox[{"-", "20.573"}]}], 
  RowBox[{"(*", "GPa", " ", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"S12", "=", "0.0"}], 
  RowBox[{"(*", "PXY", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"S13", "=", "0.0"}], 
  RowBox[{"(*", "PXZ", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"S23", "=", "0.0"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "PYZ", " ", "ELASTIC", " ", "in", " ", "LAMMPS", " ", "has", " ", "Cij",
        " ", "such", " ", "as", " ", "here", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", "-", "23"}], ",", 
         RowBox[{"5", "-", "13"}], ",", " ", 
         RowBox[{"6", "-", "12"}]}], ")"}], " ", "but", " ", "in", " ", "the",
        " ", "stresses", " ", "it", " ", "is", " ", "switched", " ", "4"}], 
      "-", "12"}], ",", 
     RowBox[{"5", "-", "13"}], ",", 
     RowBox[{"6", "-", "23"}]}], "*)"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Stiffness_tensor", "_in", "_", "orthonormal", "_", "notation"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ST", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"C11all", "C12all", "C13all", 
       RowBox[{
        SqrtBox["2"], "*", "C14all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C15all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C16all"}]},
      {"C12all", "C22all", "C23all", 
       RowBox[{
        SqrtBox["2"], "*", "C24all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C25all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C26all"}]},
      {"C13all", "C23all", "C33all", 
       RowBox[{
        SqrtBox["2"], "*", "C34all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C35all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C36all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C14all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C24all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C34all"}], 
       RowBox[{"2", "*", "C44all"}], 
       RowBox[{"2", "*", "C45all"}], 
       RowBox[{"2", "*", "C46all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C15all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C25all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C35all"}], 
       RowBox[{"2", "*", "C45all"}], 
       RowBox[{"2", "*", "C55all"}], 
       RowBox[{"2", "*", "C56all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C16all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C26all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C36all"}], 
       RowBox[{"2", "*", "C46all"}], 
       RowBox[{"2", "*", "C56all"}], 
       RowBox[{"2", "*", "C66all"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ST", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"TeXForm", "[", "ST", "]"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Kelvin_moduli", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EST", "=", 
   RowBox[{"Eigenvalues", "[", "ST", "]"}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Det", "[", "ST", "]"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"EST", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "/", 
     RowBox[{"EST", "[", 
      RowBox[{"[", "6", "]"}], "]"}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"H", "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"S11", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S11"}], "-", "S22"}], ")"}]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S11"}], "-", "S33"}], ")"}]}], 
        RowBox[{"-", 
         FractionBox["S23", 
          SqrtBox["2"]]}], 
        FractionBox["S13", 
         SqrtBox["2"]], 
        FractionBox["S12", 
         SqrtBox["2"]]},
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S11"}], "-", "S22"}], ")"}]}], "S22", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S22"}], "-", "S33"}], ")"}]}], 
        FractionBox["S23", 
         SqrtBox["2"]], 
        RowBox[{"-", 
         FractionBox["S13", 
          SqrtBox["2"]]}], 
        FractionBox["S12", 
         SqrtBox["2"]]},
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S11"}], "-", "S33"}], ")"}]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S22"}], "-", "S33"}], ")"}]}], "S33", 
        FractionBox["S23", 
         SqrtBox["2"]], 
        FractionBox["S13", 
         SqrtBox["2"]], 
        RowBox[{"-", 
         FractionBox["S12", 
          SqrtBox["2"]]}]},
       {
        RowBox[{"-", 
         FractionBox["S23", 
          SqrtBox["2"]]}], 
        FractionBox["S23", 
         SqrtBox["2"]], 
        FractionBox["S23", 
         SqrtBox["2"]], 
        RowBox[{"S22", "+", "S33"}], "S12", "S13"},
       {
        FractionBox["S13", 
         SqrtBox["2"]], 
        RowBox[{"-", 
         FractionBox["S13", 
          SqrtBox["2"]]}], 
        FractionBox["S13", 
         SqrtBox["2"]], "S12", 
        RowBox[{"S11", "+", "S33"}], "S23"},
       {
        FractionBox["S12", 
         SqrtBox["2"]], 
        FractionBox["S12", 
         SqrtBox["2"]], 
        RowBox[{"-", 
         FractionBox["S12", 
          SqrtBox["2"]]}], "S13", "S23", 
        RowBox[{"S11", "+", "S22"}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"ST", "+", "H"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Kelvin_moduli", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"EL", "=", 
  RowBox[{"Eigenvalues", "[", "L", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Det", "[", "L", "]"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.8304206981954813`*^9, 3.8304207212935977`*^9}, {
   3.830421287798919*^9, 3.830421309895815*^9}, {3.8304213408394103`*^9, 
   3.8304214316395545`*^9}, {3.8304214834109364`*^9, 3.8304214926205072`*^9}, 
   3.8304219600715013`*^9, {3.8304232838226953`*^9, 3.830423294812406*^9}, {
   3.830423393877207*^9, 3.830423396444199*^9}, {3.830427512623121*^9, 
   3.8304275194899683`*^9}, {3.8304275505542936`*^9, 3.830427558748024*^9}, 
   3.830427620084891*^9, 3.8304281128519278`*^9, {3.8304282648268986`*^9, 
   3.8304283144345417`*^9}, 3.8304284687672176`*^9, {3.830428656603857*^9, 
   3.830428660096822*^9}, {3.830428850263464*^9, 3.830428853472473*^9}, {
   3.8304288837536297`*^9, 3.8304288873294115`*^9}, 3.8304312734597015`*^9, 
   3.8304313043416533`*^9, {3.8304388249893174`*^9, 3.830438828097963*^9}, {
   3.8304389017166986`*^9, 3.8304389045017195`*^9}, 3.8304394785103045`*^9, {
   3.875329295820007*^9, 3.875329324796239*^9}, {3.926817279242573*^9, 
   3.926817288439085*^9}, {3.933915146987565*^9, 3.9339151791188364`*^9}, {
   3.9339153310283527`*^9, 3.9339153837015715`*^9}, {3.9339154992665415`*^9, 
   3.9339155447651644`*^9}, {3.93391557571482*^9, 3.93391560188194*^9}, {
   3.9339157430839434`*^9, 3.9339158427005167`*^9}, 3.9339159533994064`*^9, {
   3.933916004442349*^9, 3.93391602100877*^9}, {3.933916260966919*^9, 
   3.933916355144825*^9}, {3.9339165278014836`*^9, 3.933916590859294*^9}, {
   3.933916759830981*^9, 3.93391680912029*^9}, {3.933916925242171*^9, 
   3.93391697866576*^9}, {3.9339170845897546`*^9, 3.9339171329624124`*^9}, {
   3.933917193536931*^9, 3.9339172451158075`*^9}, {3.9339175260891647`*^9, 
   3.9339175741634192`*^9}, {3.9339176606767693`*^9, 
   3.9339177046371503`*^9}, {3.9339177599377837`*^9, 3.933917814741163*^9}, {
   3.933917889710854*^9, 3.9339179368798394`*^9}, {3.9339179712800293`*^9, 
   3.9339180418010063`*^9}, {3.933918151189418*^9, 3.9339182385098195`*^9}, {
   3.9339185120850916`*^9, 3.933918531013131*^9}, {3.933918571099766*^9, 
   3.933918592191025*^9}, {3.933918653805032*^9, 3.933918667828722*^9}, {
   3.9339187264310946`*^9, 3.9339188497060733`*^9}, {3.93391895026301*^9, 
   3.933918960883492*^9}, {3.933920271911903*^9, 3.9339202819279375`*^9}, {
   3.933920321211199*^9, 3.933920378843813*^9}, {3.9339204095338564`*^9, 
   3.933920484539834*^9}, 3.9339206085630865`*^9, {3.933927244004126*^9, 
   3.9339272526988697`*^9}, {3.941350844791167*^9, 3.9413508616984053`*^9}, {
   3.941433286098939*^9, 3.941433339918329*^9}, 3.941433446669018*^9, {
   3.9414385807863665`*^9, 3.9414387034854355`*^9}, {3.9414387335939016`*^9, 
   3.941438828339793*^9}, {3.9414490663172092`*^9, 3.9414490743653307`*^9}, {
   3.941449562062811*^9, 3.9414495708121586`*^9}, 3.9414500832271175`*^9, {
   3.9414504304504137`*^9, 3.941450437047927*^9}, 3.941450499752859*^9, 
   3.9414505637203655`*^9},
 CellLabel->
  "In[2935]:=",ExpressionUUID->"258805fa-bd1e-4285-b19a-325d81a133f0"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"12.351`", "12.375`", "5.225`", "0.`", "0.`", "0.`"},
     {"12.375`", "12.351`", "5.225`", "0.`", "0.`", "0.`"},
     {"5.225`", "5.225`", "54.415`", "0.`", "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "61.726`", "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "61.726`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "0.`", "84.722`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9339156155212545`*^9, 3.9339158627649975`*^9, 3.933915960116195*^9, {
   3.9339160092068243`*^9, 3.9339160268635387`*^9}, 3.9339163577434607`*^9, 
   3.9339165941314325`*^9, 3.93391682116765*^9, 3.933916981749245*^9, 
   3.9339171374412503`*^9, 3.9339172502770386`*^9, 3.933917579847159*^9, 
   3.9339177093274574`*^9, 3.933917820982996*^9, 3.933917949937646*^9, 
   3.9339180473930693`*^9, 3.9339188540489283`*^9, 3.9339189646063623`*^9, 
   3.9339206139423676`*^9, 3.933927265092086*^9, 3.9365827172138534`*^9, 
   3.936582865031328*^9, 3.9365830136695595`*^9, 3.9413510768798313`*^9, {
   3.941432978141862*^9, 3.9414330001173415`*^9}, 3.941433089776209*^9, 
   3.941433156498397*^9, 3.9414332455481024`*^9, 3.9414335352078485`*^9, 
   3.94143429441565*^9, {3.9414345050972137`*^9, 3.941434534129123*^9}, 
   3.9414347242265234`*^9, {3.941434887619049*^9, 3.941434903954624*^9}, 
   3.941434970571433*^9, 3.941437871493595*^9, 3.941438158790465*^9, 
   3.941439365659031*^9, 3.9414394009181004`*^9, 3.941439895753643*^9, {
   3.9414399344009714`*^9, 3.9414399850732822`*^9}, 3.9414400590063*^9, 
   3.941440197094002*^9, 3.9414405583410683`*^9, 3.9414406246087675`*^9, 
   3.941440743460078*^9, 3.9414408439918976`*^9, {3.941441027724599*^9, 
   3.941441052113926*^9}, 3.941441105123272*^9, 3.9414412548618736`*^9, 
   3.9414491886155376`*^9, 3.941449688783518*^9, 3.941449954357792*^9, 
   3.941450109644373*^9, 3.9414508782363195`*^9, 3.9414510073387194`*^9, 
   3.9414514132082186`*^9, 3.9414521064905396`*^9, 3.941452171208044*^9, 
   3.941452396999547*^9, 3.9414525031623497`*^9, 3.9414527614424777`*^9, 
   3.941452822266943*^9, 3.9414530917956533`*^9, 3.941453443880131*^9},
 CellLabel->
  "Out[2963]//MatrixForm=",ExpressionUUID->"473bb0ff-7da4-4199-8efd-\
77461d412e36"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "84.722`", ",", "61.726`", ",", "61.726`", ",", "56.15243083600339`", ",", 
   "22.988569163996605`", ",", 
   RowBox[{"-", "0.024000000000002835`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9339156155212545`*^9, 3.9339158627649975`*^9, 3.933915960116195*^9, {
   3.9339160092068243`*^9, 3.9339160268635387`*^9}, 3.9339163577434607`*^9, 
   3.9339165941314325`*^9, 3.93391682116765*^9, 3.933916981749245*^9, 
   3.9339171374412503`*^9, 3.9339172502770386`*^9, 3.933917579847159*^9, 
   3.9339177093274574`*^9, 3.933917820982996*^9, 3.933917949937646*^9, 
   3.9339180473930693`*^9, 3.9339188540489283`*^9, 3.9339189646063623`*^9, 
   3.9339206139423676`*^9, 3.933927265092086*^9, 3.9365827172138534`*^9, 
   3.936582865031328*^9, 3.9365830136695595`*^9, 3.9413510768798313`*^9, {
   3.941432978141862*^9, 3.9414330001173415`*^9}, 3.941433089776209*^9, 
   3.941433156498397*^9, 3.9414332455481024`*^9, 3.9414335352078485`*^9, 
   3.94143429441565*^9, {3.9414345050972137`*^9, 3.941434534129123*^9}, 
   3.9414347242265234`*^9, {3.941434887619049*^9, 3.941434903954624*^9}, 
   3.941434970571433*^9, 3.941437871493595*^9, 3.941438158790465*^9, 
   3.941439365659031*^9, 3.9414394009181004`*^9, 3.941439895753643*^9, {
   3.9414399344009714`*^9, 3.9414399850732822`*^9}, 3.9414400590063*^9, 
   3.941440197094002*^9, 3.9414405583410683`*^9, 3.9414406246087675`*^9, 
   3.941440743460078*^9, 3.9414408439918976`*^9, {3.941441027724599*^9, 
   3.941441052113926*^9}, 3.941441105123272*^9, 3.9414412548618736`*^9, 
   3.9414491886155376`*^9, 3.941449688783518*^9, 3.941449954357792*^9, 
   3.941450109644373*^9, 3.9414508782363195`*^9, 3.9414510073387194`*^9, 
   3.9414514132082186`*^9, 3.9414521064905396`*^9, 3.941452171208044*^9, 
   3.941452396999547*^9, 3.9414525031623497`*^9, 3.9414527614424777`*^9, 
   3.941452822266943*^9, 3.9414530917956533`*^9, 3.941453443886115*^9},
 CellLabel->
  "Out[2964]=",ExpressionUUID->"ea7e746d-3fa3-4e35-95ad-2adef405f963"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "14.694999999999999`"}], "39.421`", "29.0345`", "0.`", 
      "0.`", "0.`"},
     {"39.421`", 
      RowBox[{"-", "14.694999999999999`"}], "29.0345`", "0.`", "0.`", "0.`"},
     {"29.0345`", "29.0345`", "33.842`", "0.`", "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "14.107`", "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "14.107`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "0.`", "30.629999999999995`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9339156155212545`*^9, 3.9339158627649975`*^9, 3.933915960116195*^9, {
   3.9339160092068243`*^9, 3.9339160268635387`*^9}, 3.9339163577434607`*^9, 
   3.9339165941314325`*^9, 3.93391682116765*^9, 3.933916981749245*^9, 
   3.9339171374412503`*^9, 3.9339172502770386`*^9, 3.933917579847159*^9, 
   3.9339177093274574`*^9, 3.933917820982996*^9, 3.933917949937646*^9, 
   3.9339180473930693`*^9, 3.9339188540489283`*^9, 3.9339189646063623`*^9, 
   3.9339206139423676`*^9, 3.933927265092086*^9, 3.9365827172138534`*^9, 
   3.936582865031328*^9, 3.9365830136695595`*^9, 3.9413510768798313`*^9, {
   3.941432978141862*^9, 3.9414330001173415`*^9}, 3.941433089776209*^9, 
   3.941433156498397*^9, 3.9414332455481024`*^9, 3.9414335352078485`*^9, 
   3.94143429441565*^9, {3.9414345050972137`*^9, 3.941434534129123*^9}, 
   3.9414347242265234`*^9, {3.941434887619049*^9, 3.941434903954624*^9}, 
   3.941434970571433*^9, 3.941437871493595*^9, 3.941438158790465*^9, 
   3.941439365659031*^9, 3.9414394009181004`*^9, 3.941439895753643*^9, {
   3.9414399344009714`*^9, 3.9414399850732822`*^9}, 3.9414400590063*^9, 
   3.941440197094002*^9, 3.9414405583410683`*^9, 3.9414406246087675`*^9, 
   3.941440743460078*^9, 3.9414408439918976`*^9, {3.941441027724599*^9, 
   3.941441052113926*^9}, 3.941441105123272*^9, 3.9414412548618736`*^9, 
   3.9414491886155376`*^9, 3.941449688783518*^9, 3.941449954357792*^9, 
   3.941450109644373*^9, 3.9414508782363195`*^9, 3.9414510073387194`*^9, 
   3.9414514132082186`*^9, 3.9414521064905396`*^9, 3.941452171208044*^9, 
   3.941452396999547*^9, 3.9414525031623497`*^9, 3.9414527614424777`*^9, 
   3.941452822266943*^9, 3.9414530917956533`*^9, 3.9414534438930964`*^9},
 CellLabel->
  "Out[2967]//MatrixForm=",ExpressionUUID->"ec881fd6-5cd3-4821-8740-\
18b28e58f68b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"70.59719092614368`", ",", 
   RowBox[{"-", "54.116`"}], ",", "30.629999999999995`", ",", "14.107`", ",", 
   "14.107`", ",", 
   RowBox[{"-", "12.029190926143677`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9339156155212545`*^9, 3.9339158627649975`*^9, 3.933915960116195*^9, {
   3.9339160092068243`*^9, 3.9339160268635387`*^9}, 3.9339163577434607`*^9, 
   3.9339165941314325`*^9, 3.93391682116765*^9, 3.933916981749245*^9, 
   3.9339171374412503`*^9, 3.9339172502770386`*^9, 3.933917579847159*^9, 
   3.9339177093274574`*^9, 3.933917820982996*^9, 3.933917949937646*^9, 
   3.9339180473930693`*^9, 3.9339188540489283`*^9, 3.9339189646063623`*^9, 
   3.9339206139423676`*^9, 3.933927265092086*^9, 3.9365827172138534`*^9, 
   3.936582865031328*^9, 3.9365830136695595`*^9, 3.9413510768798313`*^9, {
   3.941432978141862*^9, 3.9414330001173415`*^9}, 3.941433089776209*^9, 
   3.941433156498397*^9, 3.9414332455481024`*^9, 3.9414335352078485`*^9, 
   3.94143429441565*^9, {3.9414345050972137`*^9, 3.941434534129123*^9}, 
   3.9414347242265234`*^9, {3.941434887619049*^9, 3.941434903954624*^9}, 
   3.941434970571433*^9, 3.941437871493595*^9, 3.941438158790465*^9, 
   3.941439365659031*^9, 3.9414394009181004`*^9, 3.941439895753643*^9, {
   3.9414399344009714`*^9, 3.9414399850732822`*^9}, 3.9414400590063*^9, 
   3.941440197094002*^9, 3.9414405583410683`*^9, 3.9414406246087675`*^9, 
   3.941440743460078*^9, 3.9414408439918976`*^9, {3.941441027724599*^9, 
   3.941441052113926*^9}, 3.941441105123272*^9, 3.9414412548618736`*^9, 
   3.9414491886155376`*^9, 3.941449688783518*^9, 3.941449954357792*^9, 
   3.941450109644373*^9, 3.9414508782363195`*^9, 3.9414510073387194`*^9, 
   3.9414514132082186`*^9, 3.9414521064905396`*^9, 3.941452171208044*^9, 
   3.941452396999547*^9, 3.9414525031623497`*^9, 3.9414527614424777`*^9, 
   3.941452822266943*^9, 3.9414530917956533`*^9, 3.9414534439000797`*^9},
 CellLabel->
  "Out[2968]=",ExpressionUUID->"b728cc8a-0634-4ff4-8cab-9e9189df526e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Stiffness_tensor", ":", " ", 
    RowBox[{"NiAl_oriented", "_X"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"[", "100", "]"}], " ", "Y"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"[", "010", "]"}], " ", "Z"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"[", "001", "]"}], "_biaxial", "_strain", "_L", "_singular", 
       "_for", "_\[Alpha]"}], "=", "1.14739"}]}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.9339149966603627`*^9, 3.933915000663592*^9}, 
   3.933918117210417*^9, 3.933923702463357*^9, 3.9339264901929183`*^9, {
   3.9414388858784285`*^9, 3.9414389158723526`*^9}, {3.9414505730697017`*^9, 
   3.9414506131969175`*^9}, {3.941453069128724*^9, 3.941453070771817*^9}},
 CellLabel->
  "In[2969]:=",ExpressionUUID->"2f5409e5-1a16-4e37-a439-7ca715810f68"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"C11all", "=", "84.27273925"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C22all", "=", "84.27273925"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C33all", "=", "58.51715980"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C12all", "=", "30.99934025"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C13all", "=", "15.10775280"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C23all", "=", "15.10775280"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C44all", "=", "39.81698766"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C55all", "=", "39.81698766"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C66all", "=", "59.69167350"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C14all", "=", "0.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C15all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C16all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C24all", "=", "0.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C25all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C26all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C34all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C35all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C36all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C45all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C46all", "=", "0.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C56all", "=", "0.0"}], 
  RowBox[{"(*", "GPa", " ", "*)"}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PXX", "=", 
   RowBox[{"-", "26.656906690"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PYY", "=", 
   RowBox[{"-", "26.656906690"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PZZ", "=", 
   RowBox[{"-", "20.426956712"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PYZ", "=", "0.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PXZ", "=", " ", "0.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PXY", "=", "0.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S11", "=", "PXX"}], 
  RowBox[{"(*", "GPa", " ", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"S22", "=", "PYY"}], 
  RowBox[{"(*", "GPa", " ", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"S33", "=", "PZZ"}], 
  RowBox[{"(*", "GPa", " ", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"S12", "=", "PXY"}], 
  RowBox[{"(*", "PXY", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"S13", "=", "PXZ"}], 
  RowBox[{"(*", "PXZ", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"S23", "=", "PYZ"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "PYZ", " ", "ELASTIC", " ", "in", " ", "LAMMPS", " ", "has", " ", "Cij",
        " ", "such", " ", "as", " ", "here", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", "-", "23"}], ",", 
         RowBox[{"5", "-", "13"}], ",", " ", 
         RowBox[{"6", "-", "12"}]}], ")"}], " ", "but", " ", "in", " ", "the",
        " ", "stresses", " ", "it", " ", "is", " ", "switched", " ", "4"}], 
      "-", "12"}], ",", 
     RowBox[{"5", "-", "13"}], ",", 
     RowBox[{"6", "-", "23"}]}], "*)"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Stiffness_tensor", "_in", "_", "orthonormal", "_", "notation"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ST", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"C11all", "C12all", "C13all", 
       RowBox[{
        SqrtBox["2"], "*", "C14all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C15all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C16all"}]},
      {"C12all", "C22all", "C23all", 
       RowBox[{
        SqrtBox["2"], "*", "C24all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C25all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C26all"}]},
      {"C13all", "C23all", "C33all", 
       RowBox[{
        SqrtBox["2"], "*", "C34all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C35all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C36all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C14all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C24all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C34all"}], 
       RowBox[{"2", "*", "C44all"}], 
       RowBox[{"2", "*", "C45all"}], 
       RowBox[{"2", "*", "C46all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C15all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C25all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C35all"}], 
       RowBox[{"2", "*", "C45all"}], 
       RowBox[{"2", "*", "C55all"}], 
       RowBox[{"2", "*", "C56all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C16all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C26all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C36all"}], 
       RowBox[{"2", "*", "C46all"}], 
       RowBox[{"2", "*", "C56all"}], 
       RowBox[{"2", "*", "C66all"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ST", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"TeXForm", "[", "ST", "]"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Kelvin_moduli", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EST", "=", 
   RowBox[{"Eigenvalues", "[", "ST", "]"}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Det", "[", "ST", "]"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"EST", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "/", 
     RowBox[{"EST", "[", 
      RowBox[{"[", "6", "]"}], "]"}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"H", "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"S11", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S11"}], "-", "S22"}], ")"}]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S11"}], "-", "S33"}], ")"}]}], 
        RowBox[{"-", 
         FractionBox["S23", 
          SqrtBox["2"]]}], 
        FractionBox["S13", 
         SqrtBox["2"]], 
        FractionBox["S12", 
         SqrtBox["2"]]},
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S11"}], "-", "S22"}], ")"}]}], "S22", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S22"}], "-", "S33"}], ")"}]}], 
        FractionBox["S23", 
         SqrtBox["2"]], 
        RowBox[{"-", 
         FractionBox["S13", 
          SqrtBox["2"]]}], 
        FractionBox["S12", 
         SqrtBox["2"]]},
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S11"}], "-", "S33"}], ")"}]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S22"}], "-", "S33"}], ")"}]}], "S33", 
        FractionBox["S23", 
         SqrtBox["2"]], 
        FractionBox["S13", 
         SqrtBox["2"]], 
        RowBox[{"-", 
         FractionBox["S12", 
          SqrtBox["2"]]}]},
       {
        RowBox[{"-", 
         FractionBox["S23", 
          SqrtBox["2"]]}], 
        FractionBox["S23", 
         SqrtBox["2"]], 
        FractionBox["S23", 
         SqrtBox["2"]], 
        RowBox[{"S22", "+", "S33"}], "S12", "S13"},
       {
        FractionBox["S13", 
         SqrtBox["2"]], 
        RowBox[{"-", 
         FractionBox["S13", 
          SqrtBox["2"]]}], 
        FractionBox["S13", 
         SqrtBox["2"]], "S12", 
        RowBox[{"S11", "+", "S33"}], "S23"},
       {
        FractionBox["S12", 
         SqrtBox["2"]], 
        FractionBox["S12", 
         SqrtBox["2"]], 
        RowBox[{"-", 
         FractionBox["S12", 
          SqrtBox["2"]]}], "S13", "S23", 
        RowBox[{"S11", "+", "S22"}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"H", "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"ST", "+", "H"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Kelvin_moduli", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"EL", "=", 
  RowBox[{"Eigenvalues", "[", "L", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Det", "[", "L", "]"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.8304206981954813`*^9, 3.8304207212935977`*^9}, {
   3.830421287798919*^9, 3.830421309895815*^9}, {3.8304213408394103`*^9, 
   3.8304214316395545`*^9}, {3.8304214834109364`*^9, 3.8304214926205072`*^9}, 
   3.8304219600715013`*^9, {3.8304232838226953`*^9, 3.830423294812406*^9}, {
   3.830423393877207*^9, 3.830423396444199*^9}, {3.830427512623121*^9, 
   3.8304275194899683`*^9}, {3.8304275505542936`*^9, 3.830427558748024*^9}, 
   3.830427620084891*^9, 3.8304281128519278`*^9, {3.8304282648268986`*^9, 
   3.8304283144345417`*^9}, 3.8304284687672176`*^9, {3.830428656603857*^9, 
   3.830428660096822*^9}, {3.830428850263464*^9, 3.830428853472473*^9}, {
   3.8304288837536297`*^9, 3.8304288873294115`*^9}, 3.8304312734597015`*^9, 
   3.8304313043416533`*^9, {3.8304388249893174`*^9, 3.830438828097963*^9}, {
   3.8304389017166986`*^9, 3.8304389045017195`*^9}, 3.8304394785103045`*^9, {
   3.875329295820007*^9, 3.875329324796239*^9}, {3.926817279242573*^9, 
   3.926817288439085*^9}, {3.933915146987565*^9, 3.9339151791188364`*^9}, {
   3.9339153310283527`*^9, 3.9339153837015715`*^9}, {3.9339154992665415`*^9, 
   3.9339155447651644`*^9}, {3.93391557571482*^9, 3.93391560188194*^9}, {
   3.9339157430839434`*^9, 3.9339158427005167`*^9}, 3.9339159533994064`*^9, {
   3.933916004442349*^9, 3.93391602100877*^9}, {3.933916260966919*^9, 
   3.933916355144825*^9}, {3.9339165278014836`*^9, 3.933916590859294*^9}, {
   3.933916759830981*^9, 3.93391680912029*^9}, {3.933916925242171*^9, 
   3.93391697866576*^9}, {3.9339170845897546`*^9, 3.9339171329624124`*^9}, {
   3.933917193536931*^9, 3.9339172451158075`*^9}, {3.9339175260891647`*^9, 
   3.9339175741634192`*^9}, {3.9339176606767693`*^9, 
   3.9339177046371503`*^9}, {3.9339177599377837`*^9, 3.933917814741163*^9}, {
   3.933917889710854*^9, 3.9339179368798394`*^9}, {3.9339179712800293`*^9, 
   3.9339180418010063`*^9}, {3.933918151189418*^9, 3.9339182385098195`*^9}, {
   3.9339185120850916`*^9, 3.933918531013131*^9}, {3.933918571099766*^9, 
   3.933918592191025*^9}, {3.933918653805032*^9, 3.933918667828722*^9}, {
   3.9339187264310946`*^9, 3.9339188497060733`*^9}, {3.93391895026301*^9, 
   3.933918960883492*^9}, {3.933920271911903*^9, 3.9339202819279375`*^9}, {
   3.933920321211199*^9, 3.933920378843813*^9}, {3.9339204095338564`*^9, 
   3.933920484539834*^9}, 3.9339206085630865`*^9, {3.9339237293170557`*^9, 
   3.933923994034178*^9}, {3.9339240831511717`*^9, 3.9339242001906548`*^9}, {
   3.933924304705202*^9, 3.9339244215902586`*^9}, {3.9339244845626383`*^9, 
   3.933924599531232*^9}, {3.9339246665138893`*^9, 3.9339247798007317`*^9}, {
   3.9339255322462163`*^9, 3.9339256481780467`*^9}, {3.933925709754236*^9, 
   3.933925825248396*^9}, {3.933925891279077*^9, 3.933926024287033*^9}, {
   3.933926089772373*^9, 3.9339262120766597`*^9}, {3.9339262764759755`*^9, 
   3.933926404453945*^9}, {3.9339272042627664`*^9, 3.933927232919775*^9}, {
   3.934102448342719*^9, 3.934102453351759*^9}, {3.9413508863712616`*^9, 
   3.9413509039022627`*^9}, {3.9414333606807346`*^9, 3.941433408999751*^9}, {
   3.941438930263071*^9, 3.941439071016898*^9}, {3.941439312498866*^9, 
   3.9414393578898582`*^9}, 3.941439388863873*^9, {3.94144908792782*^9, 
   3.941449110733959*^9}, {3.941449580831689*^9, 3.9414496003058987`*^9}, {
   3.941450444968464*^9, 3.941450455960723*^9}, {3.941450655244109*^9, 
   3.941450655992406*^9}, {3.9414523638280544`*^9, 3.941452364648074*^9}},
 CellLabel->
  "In[2970]:=",ExpressionUUID->"6a9acde0-b1bd-47e9-833a-9a054da93d9a"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"84.27273925`", "30.99934025`", "15.1077528`", "0.`", "0.`", "0.`"},
     {"30.99934025`", "84.27273925`", "15.1077528`", "0.`", "0.`", "0.`"},
     {"15.1077528`", "15.1077528`", "58.5171598`", "0.`", "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "79.63397532`", "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "79.63397532`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "0.`", "119.383347`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.933924015126793*^9, 3.933924205543129*^9, 3.933924426638531*^9, 
   3.933924603999744*^9, 3.933924784813128*^9, 3.9339256526076484`*^9, 
   3.9339258300625057`*^9, 3.933926029761873*^9, 3.933926216881827*^9, 
   3.933926410244475*^9, 3.933927296049573*^9, 3.9340924713896656`*^9, 
   3.9341024568682413`*^9, 3.936582717491708*^9, 3.936582865328361*^9, 
   3.936583014013983*^9, 3.9413510771535807`*^9, {3.941432978421377*^9, 
   3.9414330004275117`*^9}, 3.941433090034096*^9, 3.9414331567527165`*^9, 
   3.941433245815895*^9, 3.9414335355310817`*^9, 3.941434294682935*^9, {
   3.9414345053830476`*^9, 3.9414345344083757`*^9}, 3.9414347245108547`*^9, {
   3.941434887906297*^9, 3.9414349042593174`*^9}, 3.9414349708606586`*^9, 
   3.9414378717713537`*^9, 3.9414381590625625`*^9, 3.941439365756051*^9, 
   3.94143940101033*^9, 3.941439895857601*^9, {3.941439934505398*^9, 
   3.9414399851706996`*^9}, 3.9414400591028786`*^9, 3.9414401971872597`*^9, 
   3.9414405584379277`*^9, 3.9414406247054253`*^9, 3.941440743554201*^9, 
   3.941440844084279*^9, {3.941441027818511*^9, 3.9414410522065735`*^9}, 
   3.9414411052133617`*^9, 3.94144125494659*^9, 3.941449188681402*^9, 
   3.941449688853361*^9, 3.941449954425603*^9, 3.9414501097052097`*^9, 
   3.9414508782971525`*^9, 3.941451007400581*^9, 3.941451413265042*^9, 
   3.9414521065485277`*^9, 3.9414521712668834`*^9, 3.9414523970613537`*^9, 
   3.9414525032202263`*^9, 3.9414527615002975`*^9, 3.941452822324815*^9, 
   3.9414530918574085`*^9, 3.941453443939942*^9},
 CellLabel->
  "Out[3004]//MatrixForm=",ExpressionUUID->"59ecb003-cda4-4c94-8d1a-\
301a3cdee89c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "122.41600218038826`", ",", "119.383347`", ",", "79.63397532`", ",", 
   "79.63397532`", ",", "53.273399000000005`", ",", "51.37323711961165`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.933924015126793*^9, 3.933924205543129*^9, 3.933924426638531*^9, 
   3.933924603999744*^9, 3.933924784813128*^9, 3.9339256526076484`*^9, 
   3.9339258300625057`*^9, 3.933926029761873*^9, 3.933926216881827*^9, 
   3.933926410244475*^9, 3.933927296049573*^9, 3.9340924713896656`*^9, 
   3.9341024568682413`*^9, 3.936582717491708*^9, 3.936582865328361*^9, 
   3.936583014013983*^9, 3.9413510771535807`*^9, {3.941432978421377*^9, 
   3.9414330004275117`*^9}, 3.941433090034096*^9, 3.9414331567527165`*^9, 
   3.941433245815895*^9, 3.9414335355310817`*^9, 3.941434294682935*^9, {
   3.9414345053830476`*^9, 3.9414345344083757`*^9}, 3.9414347245108547`*^9, {
   3.941434887906297*^9, 3.9414349042593174`*^9}, 3.9414349708606586`*^9, 
   3.9414378717713537`*^9, 3.9414381590625625`*^9, 3.941439365756051*^9, 
   3.94143940101033*^9, 3.941439895857601*^9, {3.941439934505398*^9, 
   3.9414399851706996`*^9}, 3.9414400591028786`*^9, 3.9414401971872597`*^9, 
   3.9414405584379277`*^9, 3.9414406247054253`*^9, 3.941440743554201*^9, 
   3.941440844084279*^9, {3.941441027818511*^9, 3.9414410522065735`*^9}, 
   3.9414411052133617`*^9, 3.94144125494659*^9, 3.941449188681402*^9, 
   3.941449688853361*^9, 3.941449954425603*^9, 3.9414501097052097`*^9, 
   3.9414508782971525`*^9, 3.941451007400581*^9, 3.941451413265042*^9, 
   3.9414521065485277`*^9, 3.9414521712668834`*^9, 3.9414523970613537`*^9, 
   3.9414525032202263`*^9, 3.9414527615002975`*^9, 3.941452822324815*^9, 
   3.9414530918574085`*^9, 3.9414534439449563`*^9},
 CellLabel->
  "Out[3005]=",ExpressionUUID->"97049750-18cd-48b3-88f6-299307e8aff5"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "26.65690669`"}], "26.65690669`", "23.541931701`", "0.`", 
      "0.`", "0.`"},
     {"26.65690669`", 
      RowBox[{"-", "26.65690669`"}], "23.541931701`", "0.`", "0.`", "0.`"},
     {"23.541931701`", "23.541931701`", 
      RowBox[{"-", "20.426956712`"}], "0.`", "0.`", "0.`"},
     {"0.`", "0.`", "0.`", 
      RowBox[{"-", "47.083863402`"}], "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", 
      RowBox[{"-", "47.083863402`"}], "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "0.`", 
      RowBox[{"-", "53.31381338`"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.933924015126793*^9, 3.933924205543129*^9, 3.933924426638531*^9, 
   3.933924603999744*^9, 3.933924784813128*^9, 3.9339256526076484`*^9, 
   3.9339258300625057`*^9, 3.933926029761873*^9, 3.933926216881827*^9, 
   3.933926410244475*^9, 3.933927296049573*^9, 3.9340924713896656`*^9, 
   3.9341024568682413`*^9, 3.936582717491708*^9, 3.936582865328361*^9, 
   3.936583014013983*^9, 3.9413510771535807`*^9, {3.941432978421377*^9, 
   3.9414330004275117`*^9}, 3.941433090034096*^9, 3.9414331567527165`*^9, 
   3.941433245815895*^9, 3.9414335355310817`*^9, 3.941434294682935*^9, {
   3.9414345053830476`*^9, 3.9414345344083757`*^9}, 3.9414347245108547`*^9, {
   3.941434887906297*^9, 3.9414349042593174`*^9}, 3.9414349708606586`*^9, 
   3.9414378717713537`*^9, 3.9414381590625625`*^9, 3.941439365756051*^9, 
   3.94143940101033*^9, 3.941439895857601*^9, {3.941439934505398*^9, 
   3.9414399851706996`*^9}, 3.9414400591028786`*^9, 3.9414401971872597`*^9, 
   3.9414405584379277`*^9, 3.9414406247054253`*^9, 3.941440743554201*^9, 
   3.941440844084279*^9, {3.941441027818511*^9, 3.9414410522065735`*^9}, 
   3.9414411052133617`*^9, 3.94144125494659*^9, 3.941449188681402*^9, 
   3.941449688853361*^9, 3.941449954425603*^9, 3.9414501097052097`*^9, 
   3.9414508782971525`*^9, 3.941451007400581*^9, 3.941451413265042*^9, 
   3.9414521065485277`*^9, 3.9414521712668834`*^9, 3.9414523970613537`*^9, 
   3.9414525032202263`*^9, 3.9414527615002975`*^9, 3.941452822324815*^9, 
   3.9414530918574085`*^9, 3.941453443952937*^9},
 CellLabel->
  "Out[3007]//MatrixForm=",ExpressionUUID->"1c689e8a-1340-4593-bb7d-\
98559d485e49"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"57.61583256`", "57.65624694`", "38.649684500999996`", "0.`", "0.`", 
      "0.`"},
     {"57.65624694`", "57.61583256`", "38.649684500999996`", "0.`", "0.`", 
      "0.`"},
     {"38.649684500999996`", "38.649684500999996`", "38.090203088`", "0.`", 
      "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "32.550111918000006`", "0.`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "32.550111918000006`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "0.`", "66.06953362`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.933924015126793*^9, 3.933924205543129*^9, 3.933924426638531*^9, 
   3.933924603999744*^9, 3.933924784813128*^9, 3.9339256526076484`*^9, 
   3.9339258300625057`*^9, 3.933926029761873*^9, 3.933926216881827*^9, 
   3.933926410244475*^9, 3.933927296049573*^9, 3.9340924713896656`*^9, 
   3.9341024568682413`*^9, 3.936582717491708*^9, 3.936582865328361*^9, 
   3.936583014013983*^9, 3.9413510771535807`*^9, {3.941432978421377*^9, 
   3.9414330004275117`*^9}, 3.941433090034096*^9, 3.9414331567527165`*^9, 
   3.941433245815895*^9, 3.9414335355310817`*^9, 3.941434294682935*^9, {
   3.9414345053830476`*^9, 3.9414345344083757`*^9}, 3.9414347245108547`*^9, {
   3.941434887906297*^9, 3.9414349042593174`*^9}, 3.9414349708606586`*^9, 
   3.9414378717713537`*^9, 3.9414381590625625`*^9, 3.941439365756051*^9, 
   3.94143940101033*^9, 3.941439895857601*^9, {3.941439934505398*^9, 
   3.9414399851706996`*^9}, 3.9414400591028786`*^9, 3.9414401971872597`*^9, 
   3.9414405584379277`*^9, 3.9414406247054253`*^9, 3.941440743554201*^9, 
   3.941440844084279*^9, {3.941441027818511*^9, 3.9414410522065735`*^9}, 
   3.9414411052133617`*^9, 3.94144125494659*^9, 3.941449188681402*^9, 
   3.941449688853361*^9, 3.941449954425603*^9, 3.9414501097052097`*^9, 
   3.9414508782971525`*^9, 3.941451007400581*^9, 3.941451413265042*^9, 
   3.9414521065485277`*^9, 3.9414521712668834`*^9, 3.9414523970613537`*^9, 
   3.9414525032202263`*^9, 3.9414527615002975`*^9, 3.941452822324815*^9, 
   3.9414530918574085`*^9, 3.9414534439609175`*^9},
 CellLabel->
  "Out[3009]//MatrixForm=",ExpressionUUID->"dbb02388-8de5-414a-b4b6-\
3d074ba3da9a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "143.59045855006673`", ",", "66.06953362`", ",", "32.550111918000006`", ",",
    "32.550111918000006`", ",", "9.771824037933275`", ",", 
   RowBox[{"-", "0.04041438000000239`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.933924015126793*^9, 3.933924205543129*^9, 3.933924426638531*^9, 
   3.933924603999744*^9, 3.933924784813128*^9, 3.9339256526076484`*^9, 
   3.9339258300625057`*^9, 3.933926029761873*^9, 3.933926216881827*^9, 
   3.933926410244475*^9, 3.933927296049573*^9, 3.9340924713896656`*^9, 
   3.9341024568682413`*^9, 3.936582717491708*^9, 3.936582865328361*^9, 
   3.936583014013983*^9, 3.9413510771535807`*^9, {3.941432978421377*^9, 
   3.9414330004275117`*^9}, 3.941433090034096*^9, 3.9414331567527165`*^9, 
   3.941433245815895*^9, 3.9414335355310817`*^9, 3.941434294682935*^9, {
   3.9414345053830476`*^9, 3.9414345344083757`*^9}, 3.9414347245108547`*^9, {
   3.941434887906297*^9, 3.9414349042593174`*^9}, 3.9414349708606586`*^9, 
   3.9414378717713537`*^9, 3.9414381590625625`*^9, 3.941439365756051*^9, 
   3.94143940101033*^9, 3.941439895857601*^9, {3.941439934505398*^9, 
   3.9414399851706996`*^9}, 3.9414400591028786`*^9, 3.9414401971872597`*^9, 
   3.9414405584379277`*^9, 3.9414406247054253`*^9, 3.941440743554201*^9, 
   3.941440844084279*^9, {3.941441027818511*^9, 3.9414410522065735`*^9}, 
   3.9414411052133617`*^9, 3.94144125494659*^9, 3.941449188681402*^9, 
   3.941449688853361*^9, 3.941449954425603*^9, 3.9414501097052097`*^9, 
   3.9414508782971525`*^9, 3.941451007400581*^9, 3.941451413265042*^9, 
   3.9414521065485277`*^9, 3.9414521712668834`*^9, 3.9414523970613537`*^9, 
   3.9414525032202263`*^9, 3.9414527615002975`*^9, 3.941452822324815*^9, 
   3.9414530918574085`*^9, 3.941453443966897*^9},
 CellLabel->
  "Out[3010]=",ExpressionUUID->"10f97ee0-5b67-4a98-9d9b-998a350b147b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Stiffness_tensor", ":", " ", 
    RowBox[{
    "Graphene_under", "_unixial", "_x", "_strain", "_C", "_singular", "_for", 
     "_\[Alpha]"}]}], "=", "1.2781"}], "*)"}]], "Input",
 CellChangeTimes->{{3.9414403589979343`*^9, 3.9414404111415143`*^9}, 
   3.941440523037513*^9, {3.9414506659925375`*^9, 3.9414506989387712`*^9}, 
   3.941453204792444*^9},
 CellLabel->
  "In[3011]:=",ExpressionUUID->"dc941b24-8577-4642-939d-d760334be227"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"C11all", "=", "13.18872130"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C22all", "=", "179.25865207"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C33all", "=", "2.2904217754"}], 
  RowBox[{"(*", 
   RowBox[{"C66", " ", "in", " ", "LAMMPS"}], "*)"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C12all", "=", 
   RowBox[{"-", "48.65406717"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C13all", "=", "0.0"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"C16", " ", "in", " ", "LAMMPS"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C23all", "=", "0.0"}], 
   RowBox[{"(*", 
    RowBox[{"N", "/", "m"}], " ", "*)"}], " ", ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"C26", " ", "in", " ", "LAMMPS"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PXX", "=", 
   RowBox[{"-", "38.926434014"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PYY", "=", 
   RowBox[{"-", "3.3179214930"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PXY", "=", "0.0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S11", "=", "PXX"}], 
  RowBox[{"(*", 
   RowBox[{"N", "/", "m"}], " ", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"S22", "=", "PYY"}], 
  RowBox[{"(*", 
   RowBox[{"N", "/", "m"}], " ", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"S12", "=", "PXY"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"N", "/", "m"}], " ", "ELASTIC", " ", "in", " ", "LAMMPS", " ",
        "has", " ", "Cij", " ", "such", " ", "as", " ", "here", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", "-", "23"}], ",", 
         RowBox[{"5", "-", "13"}], ",", " ", 
         RowBox[{"6", "-", "12"}]}], ")"}], " ", "but", " ", "in", " ", "the",
        " ", "stresses", " ", "it", " ", "is", " ", "switched", " ", "4"}], 
      "-", "12"}], ",", 
     RowBox[{"5", "-", "13"}], ",", 
     RowBox[{"6", "-", "23"}]}], "*)"}], ";"}], "\n", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "2", "D_", "Stiffness", "_tensor", "_in", "_", "orthonormal", "_", 
    "notation"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ST", "=", 
   RowBox[{"(", GridBox[{
      {"C11all", "C12all", 
       RowBox[{
        SqrtBox["2"], "*", "C13all"}]},
      {"C12all", "C22all", 
       RowBox[{
        SqrtBox["2"], "*", "C23all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C13all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C23all"}], 
       RowBox[{"2", "*", "C33all"}]}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ST", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Kelvin_moduli", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"EST", "=", 
  RowBox[{"Eigenvalues", "[", "ST", "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"H", "=", 
    RowBox[{"(", GridBox[{
       {"S11", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S11"}], "-", "S22"}], ")"}]}], 
        FractionBox["S12", 
         SqrtBox["2"]]},
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S11"}], "-", "S22"}], ")"}]}], "S22", 
        FractionBox["S12", 
         SqrtBox["2"]]},
       {
        FractionBox["S12", 
         SqrtBox["2"]], 
        FractionBox["S12", 
         SqrtBox["2"]], 
        RowBox[{"S11", "+", "S22"}]}
      }], ")"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"H", "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"ST", "+", "H"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Kelvin_moduli", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EL", "=", 
   RowBox[{"Eigenvalues", "[", "L", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.935551349468149*^9, 3.93555140085221*^9}, {
   3.935551466211521*^9, 3.935551622881301*^9}, {3.935551927924285*^9, 
   3.935551972969049*^9}, {3.9355520385205116`*^9, 3.9355520627488317`*^9}, {
   3.935552134304821*^9, 3.935552177223753*^9}, {3.9355522310006886`*^9, 
   3.935552241761309*^9}, {3.9355523323793716`*^9, 3.935552445525008*^9}, {
   3.935552533325288*^9, 3.9355526755511136`*^9}, {3.9355527572350655`*^9, 
   3.935552760978356*^9}, {3.935552993816186*^9, 3.9355530836358643`*^9}, {
   3.93555314234332*^9, 3.935553222464553*^9}, {3.9355533000364685`*^9, 
   3.9355533404460697`*^9}, {3.935553403017296*^9, 3.9355534411721983`*^9}, {
   3.935553497886244*^9, 3.9355535412607703`*^9}, {3.9355536044962254`*^9, 
   3.9355536610200214`*^9}, {3.935553720450955*^9, 3.9355537590128946`*^9}, {
   3.935553816452696*^9, 3.9355538655495586`*^9}, {3.935553926095373*^9, 
   3.9355539398044424`*^9}, {3.935554066346348*^9, 3.935554105380431*^9}, {
   3.9413510288200164`*^9, 3.941351039543997*^9}, {3.9414334472242517`*^9, 
   3.941433447256675*^9}, {3.9414397889161396`*^9, 3.9414398625498*^9}, 
   3.941440138587639*^9, {3.94144023823203*^9, 3.9414402449218216`*^9}, {
   3.941440492188687*^9, 3.941440500634344*^9}, {3.941440532884897*^9, 
   3.9414405341264334`*^9}, {3.941449120671183*^9, 3.9414491264926686`*^9}, {
   3.941449606132264*^9, 3.941449616017684*^9}, {3.941450711290454*^9, 
   3.9414507549943323`*^9}, {3.941451314750678*^9, 3.941451320467306*^9}, {
   3.9414528031965103`*^9, 3.941452804020904*^9}},
 CellLabel->
  "In[3012]:=",ExpressionUUID->"2cb1e926-5f49-427c-b71c-0e9592bc0736"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"13.1887213`", 
      RowBox[{"-", "48.65406717`"}], "0.`"},
     {
      RowBox[{"-", "48.65406717`"}], "179.25865207`", "0.`"},
     {"0.`", "0.`", "4.5808435508`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9355524480900135`*^9, 3.935552767052019*^9, 3.935553090992464*^9, 
   3.9355532265169907`*^9, 3.935553343629366*^9, 3.9355534456312103`*^9, 
   3.9355535449962854`*^9, 3.935553665315965*^9, 3.935553762917343*^9, 
   3.9355538699968376`*^9, 3.9355542171010847`*^9, 3.9365827188343225`*^9, 
   3.9365828667534027`*^9, 3.9365830156888895`*^9, 3.941351078478266*^9, {
   3.9414329798472414`*^9, 3.941433001946104*^9}, 3.941433091487035*^9, 
   3.9414331582227497`*^9, 3.9414332473574886`*^9, 3.94143353733619*^9, 
   3.9414342963567533`*^9, {3.94143450720525*^9, 3.9414345361833467`*^9}, 
   3.941434726333047*^9, {3.941434889825559*^9, 3.941434906265723*^9}, 
   3.9414349728464713`*^9, 3.9414378736942415`*^9, 3.9414381610337687`*^9, 
   3.941439367595129*^9, 3.941439402831503*^9, 3.941439897813898*^9, {
   3.941439935994602*^9, 3.941439985279366*^9}, 3.941440059219731*^9, 
   3.941440197291931*^9, 3.9414405585416183`*^9, 3.9414406248145266`*^9, 
   3.9414407436627274`*^9, 3.9414408441886883`*^9, {3.9414410279221725`*^9, 
   3.941441052311059*^9}, 3.941441105316144*^9, 3.9414412550285797`*^9, 
   3.941449188739251*^9, 3.9414496889122066`*^9, 3.9414499544821386`*^9, 
   3.9414501097699566`*^9, 3.941450878354596*^9, 3.941451007460393*^9, 
   3.941451413321032*^9, 3.9414521066053042`*^9, 3.9414521713232746`*^9, 
   3.941452397122222*^9, 3.941452503274645*^9, 3.941452761557143*^9, 
   3.941452822385653*^9, 3.941453091919243*^9, 3.9414534440012407`*^9},
 CellLabel->
  "Out[3025]//MatrixForm=",ExpressionUUID->"6cac9703-a283-4ed2-8db3-\
8e48ed764f7c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"192.46309508234532`", ",", "4.5808435508`", ",", 
   RowBox[{"-", "0.015721712345314387`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9355524480900135`*^9, 3.935552767052019*^9, 3.935553090992464*^9, 
   3.9355532265169907`*^9, 3.935553343629366*^9, 3.9355534456312103`*^9, 
   3.9355535449962854`*^9, 3.935553665315965*^9, 3.935553762917343*^9, 
   3.9355538699968376`*^9, 3.9355542171010847`*^9, 3.9365827188343225`*^9, 
   3.9365828667534027`*^9, 3.9365830156888895`*^9, 3.941351078478266*^9, {
   3.9414329798472414`*^9, 3.941433001946104*^9}, 3.941433091487035*^9, 
   3.9414331582227497`*^9, 3.9414332473574886`*^9, 3.94143353733619*^9, 
   3.9414342963567533`*^9, {3.94143450720525*^9, 3.9414345361833467`*^9}, 
   3.941434726333047*^9, {3.941434889825559*^9, 3.941434906265723*^9}, 
   3.9414349728464713`*^9, 3.9414378736942415`*^9, 3.9414381610337687`*^9, 
   3.941439367595129*^9, 3.941439402831503*^9, 3.941439897813898*^9, {
   3.941439935994602*^9, 3.941439985279366*^9}, 3.941440059219731*^9, 
   3.941440197291931*^9, 3.9414405585416183`*^9, 3.9414406248145266`*^9, 
   3.9414407436627274`*^9, 3.9414408441886883`*^9, {3.9414410279221725`*^9, 
   3.941441052311059*^9}, 3.941441105316144*^9, 3.9414412550285797`*^9, 
   3.941449188739251*^9, 3.9414496889122066`*^9, 3.9414499544821386`*^9, 
   3.9414501097699566`*^9, 3.941450878354596*^9, 3.941451007460393*^9, 
   3.941451413321032*^9, 3.9414521066053042`*^9, 3.9414521713232746`*^9, 
   3.941452397122222*^9, 3.941452503274645*^9, 3.941452761557143*^9, 
   3.941452822385653*^9, 3.941453091919243*^9, 3.9414534440072527`*^9},
 CellLabel->
  "Out[3026]=",ExpressionUUID->"3208674f-aca5-45fd-b2c6-dac73646e73d"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "38.926434014`"}], "21.1221777535`", "0.`"},
     {"21.1221777535`", 
      RowBox[{"-", "3.317921493`"}], "0.`"},
     {"0.`", "0.`", 
      RowBox[{"-", "42.244355507`"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9355524480900135`*^9, 3.935552767052019*^9, 3.935553090992464*^9, 
   3.9355532265169907`*^9, 3.935553343629366*^9, 3.9355534456312103`*^9, 
   3.9355535449962854`*^9, 3.935553665315965*^9, 3.935553762917343*^9, 
   3.9355538699968376`*^9, 3.9355542171010847`*^9, 3.9365827188343225`*^9, 
   3.9365828667534027`*^9, 3.9365830156888895`*^9, 3.941351078478266*^9, {
   3.9414329798472414`*^9, 3.941433001946104*^9}, 3.941433091487035*^9, 
   3.9414331582227497`*^9, 3.9414332473574886`*^9, 3.94143353733619*^9, 
   3.9414342963567533`*^9, {3.94143450720525*^9, 3.9414345361833467`*^9}, 
   3.941434726333047*^9, {3.941434889825559*^9, 3.941434906265723*^9}, 
   3.9414349728464713`*^9, 3.9414378736942415`*^9, 3.9414381610337687`*^9, 
   3.941439367595129*^9, 3.941439402831503*^9, 3.941439897813898*^9, {
   3.941439935994602*^9, 3.941439985279366*^9}, 3.941440059219731*^9, 
   3.941440197291931*^9, 3.9414405585416183`*^9, 3.9414406248145266`*^9, 
   3.9414407436627274`*^9, 3.9414408441886883`*^9, {3.9414410279221725`*^9, 
   3.941441052311059*^9}, 3.941441105316144*^9, 3.9414412550285797`*^9, 
   3.941449188739251*^9, 3.9414496889122066`*^9, 3.9414499544821386`*^9, 
   3.9414501097699566`*^9, 3.941450878354596*^9, 3.941451007460393*^9, 
   3.941451413321032*^9, 3.9414521066053042`*^9, 3.9414521713232746`*^9, 
   3.941452397122222*^9, 3.941452503274645*^9, 3.941452761557143*^9, 
   3.941452822385653*^9, 3.941453091919243*^9, 3.9414534440142374`*^9},
 CellLabel->
  "Out[3028]//MatrixForm=",ExpressionUUID->"95a08529-e2a0-476c-9892-\
f294df4b884d"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "25.737712714000004`"}], 
      RowBox[{"-", "27.531889416499997`"}], "0.`"},
     {
      RowBox[{"-", "27.531889416499997`"}], "175.940730577`", "0.`"},
     {"0.`", "0.`", 
      RowBox[{"-", "37.663511956200004`"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9355524480900135`*^9, 3.935552767052019*^9, 3.935553090992464*^9, 
   3.9355532265169907`*^9, 3.935553343629366*^9, 3.9355534456312103`*^9, 
   3.9355535449962854`*^9, 3.935553665315965*^9, 3.935553762917343*^9, 
   3.9355538699968376`*^9, 3.9355542171010847`*^9, 3.9365827188343225`*^9, 
   3.9365828667534027`*^9, 3.9365830156888895`*^9, 3.941351078478266*^9, {
   3.9414329798472414`*^9, 3.941433001946104*^9}, 3.941433091487035*^9, 
   3.9414331582227497`*^9, 3.9414332473574886`*^9, 3.94143353733619*^9, 
   3.9414342963567533`*^9, {3.94143450720525*^9, 3.9414345361833467`*^9}, 
   3.941434726333047*^9, {3.941434889825559*^9, 3.941434906265723*^9}, 
   3.9414349728464713`*^9, 3.9414378736942415`*^9, 3.9414381610337687`*^9, 
   3.941439367595129*^9, 3.941439402831503*^9, 3.941439897813898*^9, {
   3.941439935994602*^9, 3.941439985279366*^9}, 3.941440059219731*^9, 
   3.941440197291931*^9, 3.9414405585416183`*^9, 3.9414406248145266`*^9, 
   3.9414407436627274`*^9, 3.9414408441886883`*^9, {3.9414410279221725`*^9, 
   3.941441052311059*^9}, 3.941441105316144*^9, 3.9414412550285797`*^9, 
   3.941449188739251*^9, 3.9414496889122066`*^9, 3.9414499544821386`*^9, 
   3.9414501097699566`*^9, 3.941450878354596*^9, 3.941451007460393*^9, 
   3.941451413321032*^9, 3.9414521066053042`*^9, 3.9414521713232746`*^9, 
   3.941452397122222*^9, 3.941452503274645*^9, 3.941452761557143*^9, 
   3.941452822385653*^9, 3.941453091919243*^9, 3.9414534440212173`*^9},
 CellLabel->
  "Out[3030]//MatrixForm=",ExpressionUUID->"632bd8fb-0186-41ff-845b-\
275d00956d0f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"179.6316651397094`", ",", 
   RowBox[{"-", "37.663511956200004`"}], ",", 
   RowBox[{"-", "29.42864727670942`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9355524480900135`*^9, 3.935552767052019*^9, 3.935553090992464*^9, 
   3.9355532265169907`*^9, 3.935553343629366*^9, 3.9355534456312103`*^9, 
   3.9355535449962854`*^9, 3.935553665315965*^9, 3.935553762917343*^9, 
   3.9355538699968376`*^9, 3.9355542171010847`*^9, 3.9365827188343225`*^9, 
   3.9365828667534027`*^9, 3.9365830156888895`*^9, 3.941351078478266*^9, {
   3.9414329798472414`*^9, 3.941433001946104*^9}, 3.941433091487035*^9, 
   3.9414331582227497`*^9, 3.9414332473574886`*^9, 3.94143353733619*^9, 
   3.9414342963567533`*^9, {3.94143450720525*^9, 3.9414345361833467`*^9}, 
   3.941434726333047*^9, {3.941434889825559*^9, 3.941434906265723*^9}, 
   3.9414349728464713`*^9, 3.9414378736942415`*^9, 3.9414381610337687`*^9, 
   3.941439367595129*^9, 3.941439402831503*^9, 3.941439897813898*^9, {
   3.941439935994602*^9, 3.941439985279366*^9}, 3.941440059219731*^9, 
   3.941440197291931*^9, 3.9414405585416183`*^9, 3.9414406248145266`*^9, 
   3.9414407436627274`*^9, 3.9414408441886883`*^9, {3.9414410279221725`*^9, 
   3.941441052311059*^9}, 3.941441105316144*^9, 3.9414412550285797`*^9, 
   3.941449188739251*^9, 3.9414496889122066`*^9, 3.9414499544821386`*^9, 
   3.9414501097699566`*^9, 3.941450878354596*^9, 3.941451007460393*^9, 
   3.941451413321032*^9, 3.9414521066053042`*^9, 3.9414521713232746`*^9, 
   3.941452397122222*^9, 3.941452503274645*^9, 3.941452761557143*^9, 
   3.941452822385653*^9, 3.941453091919243*^9, 3.9414534440271997`*^9},
 CellLabel->
  "Out[3031]=",ExpressionUUID->"9e0a03e9-4c0b-42e6-bf11-f0c1d2c976f0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Stiffness_tensor", ":", " ", 
    RowBox[{
    "Graphene_under", "_unixial", "_x", "_strain", "_L", "_singular", "_for", 
     "_\[Alpha]"}]}], "=", "1.2386"}], "*)"}]], "Input",
 CellChangeTimes->{{3.941440450573387*^9, 3.9414404597174406`*^9}, 
   3.941440510221365*^9, {3.94145076434133*^9, 3.941450791731449*^9}, 
   3.9414531959194355`*^9},
 CellLabel->
  "In[3032]:=",ExpressionUUID->"1d896bb4-d160-441a-8d59-d28885efc9e4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"C11all", "=", "40.5787048978"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C22all", "=", "194.428534180"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C33all", "=", "37.50271882554"}], 
  RowBox[{"(*", 
   RowBox[{"C66", " ", "in", " ", "LAMMPS"}], "*)"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C12all", "=", 
   RowBox[{"-", "42.9260293507"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C13all", "=", "0.0"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"C16", " ", "in", " ", "LAMMPS"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C23all", "=", "0.0"}], 
   RowBox[{"(*", 
    RowBox[{"N", "/", "m"}], " ", "*)"}], " ", ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"C26", " ", "in", " ", "LAMMPS"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PXX", "=", 
   RowBox[{"-", "38.0970124614324"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PYY", "=", 
   RowBox[{"-", "4.21462319136738"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PXY", "=", "0.0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S11", "=", "PXX"}], 
  RowBox[{"(*", 
   RowBox[{"N", "/", "m"}], " ", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"S22", "=", "PYY"}], 
  RowBox[{"(*", 
   RowBox[{"N", "/", "m"}], " ", "*)"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"S12", "=", "PXY"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"N", "/", "m"}], " ", "ELASTIC", " ", "in", " ", "LAMMPS", " ",
        "has", " ", "Cij", " ", "such", " ", "as", " ", "here", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", "-", "23"}], ",", 
         RowBox[{"5", "-", "13"}], ",", " ", 
         RowBox[{"6", "-", "12"}]}], ")"}], " ", "but", " ", "in", " ", "the",
        " ", "stresses", " ", "it", " ", "is", " ", "switched", " ", "4"}], 
      "-", "12"}], ",", 
     RowBox[{"5", "-", "13"}], ",", 
     RowBox[{"6", "-", "23"}]}], "*)"}], ";"}], "\n", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "2", "D_Stiffness", "_tensor", "_in", "_", "orthonormal", "_", 
    "notation"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ST", "=", 
   RowBox[{"(", GridBox[{
      {"C11all", "C12all", 
       RowBox[{
        SqrtBox["2"], "*", "C13all"}]},
      {"C12all", "C22all", 
       RowBox[{
        SqrtBox["2"], "*", "C23all"}]},
      {
       RowBox[{
        SqrtBox["2"], "*", "C13all"}], 
       RowBox[{
        SqrtBox["2"], "*", "C23all"}], 
       RowBox[{"2", "*", "C33all"}]}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ST", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Kelvin_moduli", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"EST", "=", 
  RowBox[{"Eigenvalues", "[", "ST", "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"H", "=", 
    RowBox[{"(", GridBox[{
       {"S11", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S11"}], "-", "S22"}], ")"}]}], 
        FractionBox["S12", 
         SqrtBox["2"]]},
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "S11"}], "-", "S22"}], ")"}]}], "S22", 
        FractionBox["S12", 
         SqrtBox["2"]]},
       {
        FractionBox["S12", 
         SqrtBox["2"]], 
        FractionBox["S12", 
         SqrtBox["2"]], 
        RowBox[{"S11", "+", "S22"}]}
      }], ")"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"H", "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"ST", "+", "H"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Kelvin_moduli", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EL", "=", 
   RowBox[{"Eigenvalues", "[", "L", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.935551349468149*^9, 3.93555140085221*^9}, {
   3.935551466211521*^9, 3.935551622881301*^9}, {3.935551927924285*^9, 
   3.935551972969049*^9}, {3.9355520385205116`*^9, 3.9355520627488317`*^9}, {
   3.935552134304821*^9, 3.935552177223753*^9}, {3.9355522310006886`*^9, 
   3.935552241761309*^9}, {3.9355523323793716`*^9, 3.935552445525008*^9}, {
   3.935552533325288*^9, 3.9355526755511136`*^9}, {3.9355527572350655`*^9, 
   3.935552760978356*^9}, {3.935552993816186*^9, 3.9355530836358643`*^9}, {
   3.93555314234332*^9, 3.935553222464553*^9}, {3.9355533000364685`*^9, 
   3.9355533404460697`*^9}, {3.935553403017296*^9, 3.9355534411721983`*^9}, {
   3.935553497886244*^9, 3.9355535412607703`*^9}, {3.9355536044962254`*^9, 
   3.9355536610200214`*^9}, {3.935553720450955*^9, 3.9355537590128946`*^9}, {
   3.935553816452696*^9, 3.9355538655495586`*^9}, {3.935553926095373*^9, 
   3.9355539398044424`*^9}, {3.935554066346348*^9, 3.935554105380431*^9}, {
   3.9355570681757717`*^9, 3.935557145360456*^9}, {3.9355572059738684`*^9, 
   3.935557287428193*^9}, {3.935557429555251*^9, 3.935557500335346*^9}, {
   3.9355576197386827`*^9, 3.9355577042955413`*^9}, {3.935557860054697*^9, 
   3.9355579319189262`*^9}, {3.935558002210702*^9, 3.9355580458799314`*^9}, {
   3.935558110012455*^9, 3.935558121474941*^9}, {3.9355581862978*^9, 
   3.93555826270235*^9}, {3.9355583632159405`*^9, 3.935558440703432*^9}, {
   3.9413510505160694`*^9, 3.94135106101194*^9}, {3.941433447274136*^9, 
   3.9414334473055596`*^9}, {3.941440014477118*^9, 3.9414400371938467`*^9}, {
   3.9414400821233983`*^9, 3.941440083443319*^9}, 3.9414401509227953`*^9, {
   3.9414402809349794`*^9, 3.9414402825510063`*^9}, {3.9414405376535277`*^9, 
   3.94144055173225*^9}, {3.9414491402304907`*^9, 3.941449145923312*^9}, {
   3.9414496221264973`*^9, 3.9414496415297976`*^9}, {3.9414508024316964`*^9, 
   3.941450823992196*^9}, {3.941452688683427*^9, 3.9414526894454513`*^9}},
 CellLabel->
  "In[3033]:=",ExpressionUUID->"d2a4bf2e-780c-471a-9f5b-2813553ebf14"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"40.5787048978`", 
      RowBox[{"-", "42.9260293507`"}], "0.`"},
     {
      RowBox[{"-", "42.9260293507`"}], "194.42853418`", "0.`"},
     {"0.`", "0.`", "75.00543765108`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.935557149065463*^9, 3.9355572900953207`*^9, 3.9355575048803563`*^9, 
   3.9355577089295187`*^9, 3.935557935519003*^9, 3.935558126134922*^9, 
   3.935558267248906*^9, 3.9355584458556876`*^9, 3.9365827189492216`*^9, 
   3.9365828668843436`*^9, 3.93658301583148*^9, 3.941351078577701*^9, {
   3.941432979979888*^9, 3.94143300208972*^9}, 3.941433091666109*^9, 
   3.9414331583715506`*^9, 3.941433247515066*^9, 3.94143353749674*^9, 
   3.941434296519367*^9, {3.9414345073768435`*^9, 3.9414345363628654`*^9}, 
   3.94143472653458*^9, {3.941434890021036*^9, 3.9414349064627895`*^9}, 
   3.941434973053481*^9, 3.9414378738930993`*^9, 3.9414381612398205`*^9, 
   3.9414393678193903`*^9, 3.9414394030572996`*^9, 3.941439897947525*^9, {
   3.9414399361383266`*^9, 3.9414399854115887`*^9}, 3.941440059353763*^9, 
   3.9414401974202623`*^9, 3.941440558694253*^9, 3.9414406249733133`*^9, 
   3.941440743811479*^9, 3.9414408443433404`*^9, {3.9414410280698366`*^9, 
   3.94144105246198*^9}, 3.941441105466019*^9, 3.9414412551111794`*^9, 
   3.94144918879906*^9, 3.941449688970046*^9, 3.9414499545454206`*^9, 
   3.941450109824024*^9, 3.941450878411414*^9, 3.941451007519268*^9, 
   3.9414514133768826`*^9, 3.9414521066624303`*^9, 3.941452171378129*^9, 
   3.94145239718996*^9, 3.9414525033294983`*^9, 3.94145276162755*^9, 
   3.9414528224484572`*^9, 3.94145309198009*^9, 3.941453444059114*^9},
 CellLabel->
  "Out[3046]//MatrixForm=",ExpressionUUID->"730a5702-8fd5-4ada-bf52-\
983f59f50e00"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "205.5949726239655`", ",", "75.00543765108`", ",", "29.412266453834505`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.935557149065463*^9, 3.9355572900953207`*^9, 3.9355575048803563`*^9, 
   3.9355577089295187`*^9, 3.935557935519003*^9, 3.935558126134922*^9, 
   3.935558267248906*^9, 3.9355584458556876`*^9, 3.9365827189492216`*^9, 
   3.9365828668843436`*^9, 3.93658301583148*^9, 3.941351078577701*^9, {
   3.941432979979888*^9, 3.94143300208972*^9}, 3.941433091666109*^9, 
   3.9414331583715506`*^9, 3.941433247515066*^9, 3.94143353749674*^9, 
   3.941434296519367*^9, {3.9414345073768435`*^9, 3.9414345363628654`*^9}, 
   3.94143472653458*^9, {3.941434890021036*^9, 3.9414349064627895`*^9}, 
   3.941434973053481*^9, 3.9414378738930993`*^9, 3.9414381612398205`*^9, 
   3.9414393678193903`*^9, 3.9414394030572996`*^9, 3.941439897947525*^9, {
   3.9414399361383266`*^9, 3.9414399854115887`*^9}, 3.941440059353763*^9, 
   3.9414401974202623`*^9, 3.941440558694253*^9, 3.9414406249733133`*^9, 
   3.941440743811479*^9, 3.9414408443433404`*^9, {3.9414410280698366`*^9, 
   3.94144105246198*^9}, 3.941441105466019*^9, 3.9414412551111794`*^9, 
   3.94144918879906*^9, 3.941449688970046*^9, 3.9414499545454206`*^9, 
   3.941450109824024*^9, 3.941450878411414*^9, 3.941451007519268*^9, 
   3.9414514133768826`*^9, 3.9414521066624303`*^9, 3.941452171378129*^9, 
   3.94145239718996*^9, 3.9414525033294983`*^9, 3.94145276162755*^9, 
   3.9414528224484572`*^9, 3.94145309198009*^9, 3.941453444065097*^9},
 CellLabel->
  "Out[3047]=",ExpressionUUID->"4b774876-1aec-4728-be6e-4f929079d482"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "38.0970124614324`"}], "21.15581782639989`", "0.`"},
     {"21.15581782639989`", 
      RowBox[{"-", "4.21462319136738`"}], "0.`"},
     {"0.`", "0.`", 
      RowBox[{"-", "42.31163565279978`"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.935557149065463*^9, 3.9355572900953207`*^9, 3.9355575048803563`*^9, 
   3.9355577089295187`*^9, 3.935557935519003*^9, 3.935558126134922*^9, 
   3.935558267248906*^9, 3.9355584458556876`*^9, 3.9365827189492216`*^9, 
   3.9365828668843436`*^9, 3.93658301583148*^9, 3.941351078577701*^9, {
   3.941432979979888*^9, 3.94143300208972*^9}, 3.941433091666109*^9, 
   3.9414331583715506`*^9, 3.941433247515066*^9, 3.94143353749674*^9, 
   3.941434296519367*^9, {3.9414345073768435`*^9, 3.9414345363628654`*^9}, 
   3.94143472653458*^9, {3.941434890021036*^9, 3.9414349064627895`*^9}, 
   3.941434973053481*^9, 3.9414378738930993`*^9, 3.9414381612398205`*^9, 
   3.9414393678193903`*^9, 3.9414394030572996`*^9, 3.941439897947525*^9, {
   3.9414399361383266`*^9, 3.9414399854115887`*^9}, 3.941440059353763*^9, 
   3.9414401974202623`*^9, 3.941440558694253*^9, 3.9414406249733133`*^9, 
   3.941440743811479*^9, 3.9414408443433404`*^9, {3.9414410280698366`*^9, 
   3.94144105246198*^9}, 3.941441105466019*^9, 3.9414412551111794`*^9, 
   3.94144918879906*^9, 3.941449688970046*^9, 3.9414499545454206`*^9, 
   3.941450109824024*^9, 3.941450878411414*^9, 3.941451007519268*^9, 
   3.9414514133768826`*^9, 3.9414521066624303`*^9, 3.941452171378129*^9, 
   3.94145239718996*^9, 3.9414525033294983`*^9, 3.94145276162755*^9, 
   3.9414528224484572`*^9, 3.94145309198009*^9, 3.941453444071082*^9},
 CellLabel->
  "Out[3049]//MatrixForm=",ExpressionUUID->"446a6969-fce4-4b80-ae0d-\
2c104e93ba32"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2.4816924363676023`", 
      RowBox[{"-", "21.77021152430011`"}], "0.`"},
     {
      RowBox[{"-", "21.77021152430011`"}], "190.21391098863262`", "0.`"},
     {"0.`", "0.`", "32.69380199828022`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.935557149065463*^9, 3.9355572900953207`*^9, 3.9355575048803563`*^9, 
   3.9355577089295187`*^9, 3.935557935519003*^9, 3.935558126134922*^9, 
   3.935558267248906*^9, 3.9355584458556876`*^9, 3.9365827189492216`*^9, 
   3.9365828668843436`*^9, 3.93658301583148*^9, 3.941351078577701*^9, {
   3.941432979979888*^9, 3.94143300208972*^9}, 3.941433091666109*^9, 
   3.9414331583715506`*^9, 3.941433247515066*^9, 3.94143353749674*^9, 
   3.941434296519367*^9, {3.9414345073768435`*^9, 3.9414345363628654`*^9}, 
   3.94143472653458*^9, {3.941434890021036*^9, 3.9414349064627895`*^9}, 
   3.941434973053481*^9, 3.9414378738930993`*^9, 3.9414381612398205`*^9, 
   3.9414393678193903`*^9, 3.9414394030572996`*^9, 3.941439897947525*^9, {
   3.9414399361383266`*^9, 3.9414399854115887`*^9}, 3.941440059353763*^9, 
   3.9414401974202623`*^9, 3.941440558694253*^9, 3.9414406249733133`*^9, 
   3.941440743811479*^9, 3.9414408443433404`*^9, {3.9414410280698366`*^9, 
   3.94144105246198*^9}, 3.941441105466019*^9, 3.9414412551111794`*^9, 
   3.94144918879906*^9, 3.941449688970046*^9, 3.9414499545454206`*^9, 
   3.941450109824024*^9, 3.941450878411414*^9, 3.941451007519268*^9, 
   3.9414514133768826`*^9, 3.9414521066624303`*^9, 3.941452171378129*^9, 
   3.94145239718996*^9, 3.9414525033294983`*^9, 3.94145276162755*^9, 
   3.9414528224484572`*^9, 3.94145309198009*^9, 3.941453444078065*^9},
 CellLabel->
  "Out[3051]//MatrixForm=",ExpressionUUID->"c5c02032-4420-4c12-905c-\
f2dfb5766000"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"192.70540950997304`", ",", "32.69380199828022`", ",", 
   RowBox[{"-", "0.00980608497283253`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.935557149065463*^9, 3.9355572900953207`*^9, 3.9355575048803563`*^9, 
   3.9355577089295187`*^9, 3.935557935519003*^9, 3.935558126134922*^9, 
   3.935558267248906*^9, 3.9355584458556876`*^9, 3.9365827189492216`*^9, 
   3.9365828668843436`*^9, 3.93658301583148*^9, 3.941351078577701*^9, {
   3.941432979979888*^9, 3.94143300208972*^9}, 3.941433091666109*^9, 
   3.9414331583715506`*^9, 3.941433247515066*^9, 3.94143353749674*^9, 
   3.941434296519367*^9, {3.9414345073768435`*^9, 3.9414345363628654`*^9}, 
   3.94143472653458*^9, {3.941434890021036*^9, 3.9414349064627895`*^9}, 
   3.941434973053481*^9, 3.9414378738930993`*^9, 3.9414381612398205`*^9, 
   3.9414393678193903`*^9, 3.9414394030572996`*^9, 3.941439897947525*^9, {
   3.9414399361383266`*^9, 3.9414399854115887`*^9}, 3.941440059353763*^9, 
   3.9414401974202623`*^9, 3.941440558694253*^9, 3.9414406249733133`*^9, 
   3.941440743811479*^9, 3.9414408443433404`*^9, {3.9414410280698366`*^9, 
   3.94144105246198*^9}, 3.941441105466019*^9, 3.9414412551111794`*^9, 
   3.94144918879906*^9, 3.941449688970046*^9, 3.9414499545454206`*^9, 
   3.941450109824024*^9, 3.941450878411414*^9, 3.941451007519268*^9, 
   3.9414514133768826`*^9, 3.9414521066624303`*^9, 3.941452171378129*^9, 
   3.94145239718996*^9, 3.9414525033294983`*^9, 3.94145276162755*^9, 
   3.9414528224484572`*^9, 3.94145309198009*^9, 3.9414534440840473`*^9},
 CellLabel->
  "Out[3052]=",ExpressionUUID->"cc8fca87-7907-4374-b567-53b7282c0b7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Stress_as", "_second"}], "-", "order_tensor"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Sigma]", "=", 
     RowBox[{"(", GridBox[{
        {"\[Sigma]11", "\[Sigma]12", "\[Sigma]13"},
        {"\[Sigma]12", "\[Sigma]22", "\[Sigma]23"},
        {"\[Sigma]13", "\[Sigma]23", "\[Sigma]33"}
       }], ")"}]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{"\[Sigma]", "//", "MatrixForm"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Stress_in", "_", "orthonormal", "_notation"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Sigma]o", "=", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]11", ",", "\[Sigma]22", ",", "\[Sigma]33", ",", " ", 
       RowBox[{
        SqrtBox["2"], "\[Sigma]23"}], ",", " ", 
       RowBox[{
        SqrtBox["2"], "\[Sigma]13"}], ",", " ", 
       RowBox[{
        SqrtBox["2"], "\[Sigma]12"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"\[Sigma]o", "//", "MatrixForm"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Stress_in", "_Voigt", "_notation"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Sigma]V", "=", 
     RowBox[{"{", 
      RowBox[{
      "\[Sigma]11", ",", "\[Sigma]22", ",", "\[Sigma]33", ",", " ", 
       "\[Sigma]23", ",", " ", "\[Sigma]13", ",", " ", "\[Sigma]12"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"\[Sigma]V", "//", "MatrixForm"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Frobenius", "_", "norm", "_", "of", "_", "\[Sigma]"}], ",", " ", 
     RowBox[{"_", "\[Sigma]o", "_", "and", "_", "\[Sigma]V"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Norm", "[", 
      RowBox[{"\[Sigma]", ",", "\"\<Frobenius\>\""}], "]"}], ")"}], "^", 
    "2"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Norm", "[", 
      RowBox[{"\[Sigma]o", ",", "\"\<Frobenius\>\""}], "]"}], ")"}], "^", 
    "2"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Norm", "[", 
      RowBox[{"\[Sigma]V", ",", "\"\<Frobenius\>\""}], "]"}], ")"}], "^", 
    "2"}]}]}]], "Input",
 CellChangeTimes->{{3.93657995627599*^9, 3.936579956276988*^9}, {
   3.9365799942873755`*^9, 3.936580087829243*^9}, {3.9365801273974743`*^9, 
   3.9365801304828978`*^9}, {3.9365801924041395`*^9, 
   3.9365802827623835`*^9}, {3.9365803239219847`*^9, 
   3.9365803669149323`*^9}, {3.9365804067490516`*^9, 
   3.9365805971870947`*^9}, {3.9365806344224644`*^9, 
   3.9365808883235645`*^9}, {3.936580936664277*^9, 3.9365809997491064`*^9}, {
   3.936581060315461*^9, 3.936581121363963*^9}, {3.93658116197591*^9, 
   3.9365812180073867`*^9}, {3.9365812720400686`*^9, 3.9365812989498153`*^9}, 
   3.9365813683836813`*^9, 3.9365814038497143`*^9, {3.9365814796495595`*^9, 
   3.93658148127065*^9}, {3.9365815137054596`*^9, 3.9365815719532523`*^9}, {
   3.936581657622961*^9, 3.936581716738746*^9}, {3.9365819324230056`*^9, 
   3.9365819595535393`*^9}, {3.9365820303002386`*^9, 
   3.9365820454619026`*^9}, {3.936582124320837*^9, 3.9365821382508745`*^9}, {
   3.9365821736714*^9, 3.9365822621116905`*^9}, {3.9365827738213835`*^9, 
   3.9365829818198876`*^9}, {3.941440593331986*^9, 3.9414406193506913`*^9}, {
   3.941440734095549*^9, 3.9414407384279737`*^9}, {3.9414491587267456`*^9, 
   3.9414491789333177`*^9}, {3.9414496465234976`*^9, 3.941449682633444*^9}, {
   3.9414508347451496`*^9, 3.941450872920391*^9}, {3.9414509554804535`*^9, 
   3.9414509941441545`*^9}, {3.941451066604832*^9, 3.9414511528713875`*^9}, {
   3.9414511924232917`*^9, 3.9414511948841405`*^9}, {3.9414512375477705`*^9, 
   3.9414512884294243`*^9}, 3.9414532743958845`*^9},
 CellLabel->
  "In[3053]:=",ExpressionUUID->"fad05642-9298-4d10-ae13-aafb91a017ec"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\[Sigma]11", "\[Sigma]12", "\[Sigma]13"},
     {"\[Sigma]12", "\[Sigma]22", "\[Sigma]23"},
     {"\[Sigma]13", "\[Sigma]23", "\[Sigma]33"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9365800908722477`*^9, 3.9365801331381464`*^9, 3.9365801984287405`*^9, 
   3.9365803694318423`*^9, 3.936580599259467*^9, {3.9365808044283323`*^9, 
   3.93658083986444*^9}, {3.936580879816351*^9, 3.9365808901604004`*^9}, 
   3.936580964166052*^9, 3.936581304764086*^9, 3.936581373096663*^9, 
   3.9365814887653837`*^9, 3.936581546497142*^9, 3.9365816742864876`*^9, 
   3.9365817215673404`*^9, 3.936581905468855*^9, 3.936581962574057*^9, {
   3.9365820372735863`*^9, 3.93658205116216*^9}, 3.9365821581740108`*^9, 
   3.9365822751845694`*^9, 3.936582719126978*^9, {3.9365828389451804`*^9, 
   3.936582881263*^9}, 3.9365829228809147`*^9, 3.9365829849676285`*^9, 
   3.9365830160149937`*^9, 3.9413510787314863`*^9, {3.9414329801663885`*^9, 
   3.9414330022891855`*^9}, 3.941433091859641*^9, 3.9414331586398325`*^9, 
   3.941433247717605*^9, 3.941433537656366*^9, 3.941434296682457*^9, {
   3.9414345075454483`*^9, 3.941434536543383*^9}, 3.9414347267201343`*^9, {
   3.941434890216775*^9, 3.941434906663334*^9}, 3.9414349732619944`*^9, 
   3.9414378740955715`*^9, 3.941438161450822*^9, 3.9414393680538445`*^9, 
   3.9414394032783213`*^9, 3.9414398981755753`*^9, {3.941439936370954*^9, 
   3.941439985648348*^9}, 3.9414400595313473`*^9, 3.941440197550312*^9, 
   3.941440558841687*^9, 3.9414406251222253`*^9, 3.941440743960739*^9, 
   3.9414408444994392`*^9, {3.9414410282232256`*^9, 3.941441052612735*^9}, 
   3.9414411056175823`*^9, 3.941441255191676*^9, 3.941449188854942*^9, 
   3.9414496890268955`*^9, 3.9414499545957947`*^9, 3.9414501098768897`*^9, 
   3.9414508784652977`*^9, {3.9414510001068287`*^9, 3.9414510075741477`*^9}, 
   3.941451413425783*^9, 3.9414521067135663`*^9, 3.9414521714299855`*^9, 
   3.941452397247778*^9, 3.9414525033796263`*^9, 3.941452761680439*^9, 
   3.94145282250331*^9, 3.9414530920409184`*^9, 3.9414534441109743`*^9},
 CellLabel->
  "Out[3054]//MatrixForm=",ExpressionUUID->"9eb70599-f73b-4a81-8ab6-\
382f3ffc7ee9"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"\[Sigma]11"},
      {"\[Sigma]22"},
      {"\[Sigma]33"},
      {
       RowBox[{
        SqrtBox["2"], " ", "\[Sigma]23"}]},
      {
       RowBox[{
        SqrtBox["2"], " ", "\[Sigma]13"}]},
      {
       RowBox[{
        SqrtBox["2"], " ", "\[Sigma]12"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9365800908722477`*^9, 3.9365801331381464`*^9, 3.9365801984287405`*^9, 
   3.9365803694318423`*^9, 3.936580599259467*^9, {3.9365808044283323`*^9, 
   3.93658083986444*^9}, {3.936580879816351*^9, 3.9365808901604004`*^9}, 
   3.936580964166052*^9, 3.936581304764086*^9, 3.936581373096663*^9, 
   3.9365814887653837`*^9, 3.936581546497142*^9, 3.9365816742864876`*^9, 
   3.9365817215673404`*^9, 3.936581905468855*^9, 3.936581962574057*^9, {
   3.9365820372735863`*^9, 3.93658205116216*^9}, 3.9365821581740108`*^9, 
   3.9365822751845694`*^9, 3.936582719126978*^9, {3.9365828389451804`*^9, 
   3.936582881263*^9}, 3.9365829228809147`*^9, 3.9365829849676285`*^9, 
   3.9365830160149937`*^9, 3.9413510787314863`*^9, {3.9414329801663885`*^9, 
   3.9414330022891855`*^9}, 3.941433091859641*^9, 3.9414331586398325`*^9, 
   3.941433247717605*^9, 3.941433537656366*^9, 3.941434296682457*^9, {
   3.9414345075454483`*^9, 3.941434536543383*^9}, 3.9414347267201343`*^9, {
   3.941434890216775*^9, 3.941434906663334*^9}, 3.9414349732619944`*^9, 
   3.9414378740955715`*^9, 3.941438161450822*^9, 3.9414393680538445`*^9, 
   3.9414394032783213`*^9, 3.9414398981755753`*^9, {3.941439936370954*^9, 
   3.941439985648348*^9}, 3.9414400595313473`*^9, 3.941440197550312*^9, 
   3.941440558841687*^9, 3.9414406251222253`*^9, 3.941440743960739*^9, 
   3.9414408444994392`*^9, {3.9414410282232256`*^9, 3.941441052612735*^9}, 
   3.9414411056175823`*^9, 3.941441255191676*^9, 3.941449188854942*^9, 
   3.9414496890268955`*^9, 3.9414499545957947`*^9, 3.9414501098768897`*^9, 
   3.9414508784652977`*^9, {3.9414510001068287`*^9, 3.9414510075741477`*^9}, 
   3.941451413425783*^9, 3.9414521067135663`*^9, 3.9414521714299855`*^9, 
   3.941452397247778*^9, 3.9414525033796263`*^9, 3.941452761680439*^9, 
   3.94145282250331*^9, 3.9414530920409184`*^9, 3.941453444118924*^9},
 CellLabel->
  "Out[3056]//MatrixForm=",ExpressionUUID->"7ba1360e-e12c-4733-a5d2-\
579eb2392102"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"\[Sigma]11"},
      {"\[Sigma]22"},
      {"\[Sigma]33"},
      {"\[Sigma]23"},
      {"\[Sigma]13"},
      {"\[Sigma]12"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9365800908722477`*^9, 3.9365801331381464`*^9, 3.9365801984287405`*^9, 
   3.9365803694318423`*^9, 3.936580599259467*^9, {3.9365808044283323`*^9, 
   3.93658083986444*^9}, {3.936580879816351*^9, 3.9365808901604004`*^9}, 
   3.936580964166052*^9, 3.936581304764086*^9, 3.936581373096663*^9, 
   3.9365814887653837`*^9, 3.936581546497142*^9, 3.9365816742864876`*^9, 
   3.9365817215673404`*^9, 3.936581905468855*^9, 3.936581962574057*^9, {
   3.9365820372735863`*^9, 3.93658205116216*^9}, 3.9365821581740108`*^9, 
   3.9365822751845694`*^9, 3.936582719126978*^9, {3.9365828389451804`*^9, 
   3.936582881263*^9}, 3.9365829228809147`*^9, 3.9365829849676285`*^9, 
   3.9365830160149937`*^9, 3.9413510787314863`*^9, {3.9414329801663885`*^9, 
   3.9414330022891855`*^9}, 3.941433091859641*^9, 3.9414331586398325`*^9, 
   3.941433247717605*^9, 3.941433537656366*^9, 3.941434296682457*^9, {
   3.9414345075454483`*^9, 3.941434536543383*^9}, 3.9414347267201343`*^9, {
   3.941434890216775*^9, 3.941434906663334*^9}, 3.9414349732619944`*^9, 
   3.9414378740955715`*^9, 3.941438161450822*^9, 3.9414393680538445`*^9, 
   3.9414394032783213`*^9, 3.9414398981755753`*^9, {3.941439936370954*^9, 
   3.941439985648348*^9}, 3.9414400595313473`*^9, 3.941440197550312*^9, 
   3.941440558841687*^9, 3.9414406251222253`*^9, 3.941440743960739*^9, 
   3.9414408444994392`*^9, {3.9414410282232256`*^9, 3.941441052612735*^9}, 
   3.9414411056175823`*^9, 3.941441255191676*^9, 3.941449188854942*^9, 
   3.9414496890268955`*^9, 3.9414499545957947`*^9, 3.9414501098768897`*^9, 
   3.9414508784652977`*^9, {3.9414510001068287`*^9, 3.9414510075741477`*^9}, 
   3.941451413425783*^9, 3.9414521067135663`*^9, 3.9414521714299855`*^9, 
   3.941452397247778*^9, 3.9414525033796263`*^9, 3.941452761680439*^9, 
   3.94145282250331*^9, 3.9414530920409184`*^9, 3.9414534441259336`*^9},
 CellLabel->
  "Out[3058]//MatrixForm=",ExpressionUUID->"277592ce-2440-400e-ab54-\
b6bc4f1bdc8f"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Abs", "[", "\[Sigma]11", "]"}], "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "\[Sigma]12", "]"}], "2"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "\[Sigma]13", "]"}], "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"Abs", "[", "\[Sigma]22", "]"}], "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "\[Sigma]23", "]"}], "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"Abs", "[", "\[Sigma]33", "]"}], "2"]}]], "Output",
 CellChangeTimes->{
  3.9365800908722477`*^9, 3.9365801331381464`*^9, 3.9365801984287405`*^9, 
   3.9365803694318423`*^9, 3.936580599259467*^9, {3.9365808044283323`*^9, 
   3.93658083986444*^9}, {3.936580879816351*^9, 3.9365808901604004`*^9}, 
   3.936580964166052*^9, 3.936581304764086*^9, 3.936581373096663*^9, 
   3.9365814887653837`*^9, 3.936581546497142*^9, 3.9365816742864876`*^9, 
   3.9365817215673404`*^9, 3.936581905468855*^9, 3.936581962574057*^9, {
   3.9365820372735863`*^9, 3.93658205116216*^9}, 3.9365821581740108`*^9, 
   3.9365822751845694`*^9, 3.936582719126978*^9, {3.9365828389451804`*^9, 
   3.936582881263*^9}, 3.9365829228809147`*^9, 3.9365829849676285`*^9, 
   3.9365830160149937`*^9, 3.9413510787314863`*^9, {3.9414329801663885`*^9, 
   3.9414330022891855`*^9}, 3.941433091859641*^9, 3.9414331586398325`*^9, 
   3.941433247717605*^9, 3.941433537656366*^9, 3.941434296682457*^9, {
   3.9414345075454483`*^9, 3.941434536543383*^9}, 3.9414347267201343`*^9, {
   3.941434890216775*^9, 3.941434906663334*^9}, 3.9414349732619944`*^9, 
   3.9414378740955715`*^9, 3.941438161450822*^9, 3.9414393680538445`*^9, 
   3.9414394032783213`*^9, 3.9414398981755753`*^9, {3.941439936370954*^9, 
   3.941439985648348*^9}, 3.9414400595313473`*^9, 3.941440197550312*^9, 
   3.941440558841687*^9, 3.9414406251222253`*^9, 3.941440743960739*^9, 
   3.9414408444994392`*^9, {3.9414410282232256`*^9, 3.941441052612735*^9}, 
   3.9414411056175823`*^9, 3.941441255191676*^9, 3.941449188854942*^9, 
   3.9414496890268955`*^9, 3.9414499545957947`*^9, 3.9414501098768897`*^9, 
   3.9414508784652977`*^9, {3.9414510001068287`*^9, 3.9414510075741477`*^9}, 
   3.941451413425783*^9, 3.9414521067135663`*^9, 3.9414521714299855`*^9, 
   3.941452397247778*^9, 3.9414525033796263`*^9, 3.941452761680439*^9, 
   3.94145282250331*^9, 3.9414530920409184`*^9, 3.941453444132916*^9},
 CellLabel->
  "Out[3059]=",ExpressionUUID->"5a8d7d0d-495f-45c6-803b-81c3f1bd563b"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Abs", "[", "\[Sigma]11", "]"}], "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "\[Sigma]12", "]"}], "2"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "\[Sigma]13", "]"}], "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"Abs", "[", "\[Sigma]22", "]"}], "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "\[Sigma]23", "]"}], "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"Abs", "[", "\[Sigma]33", "]"}], "2"]}]], "Output",
 CellChangeTimes->{
  3.9365800908722477`*^9, 3.9365801331381464`*^9, 3.9365801984287405`*^9, 
   3.9365803694318423`*^9, 3.936580599259467*^9, {3.9365808044283323`*^9, 
   3.93658083986444*^9}, {3.936580879816351*^9, 3.9365808901604004`*^9}, 
   3.936580964166052*^9, 3.936581304764086*^9, 3.936581373096663*^9, 
   3.9365814887653837`*^9, 3.936581546497142*^9, 3.9365816742864876`*^9, 
   3.9365817215673404`*^9, 3.936581905468855*^9, 3.936581962574057*^9, {
   3.9365820372735863`*^9, 3.93658205116216*^9}, 3.9365821581740108`*^9, 
   3.9365822751845694`*^9, 3.936582719126978*^9, {3.9365828389451804`*^9, 
   3.936582881263*^9}, 3.9365829228809147`*^9, 3.9365829849676285`*^9, 
   3.9365830160149937`*^9, 3.9413510787314863`*^9, {3.9414329801663885`*^9, 
   3.9414330022891855`*^9}, 3.941433091859641*^9, 3.9414331586398325`*^9, 
   3.941433247717605*^9, 3.941433537656366*^9, 3.941434296682457*^9, {
   3.9414345075454483`*^9, 3.941434536543383*^9}, 3.9414347267201343`*^9, {
   3.941434890216775*^9, 3.941434906663334*^9}, 3.9414349732619944`*^9, 
   3.9414378740955715`*^9, 3.941438161450822*^9, 3.9414393680538445`*^9, 
   3.9414394032783213`*^9, 3.9414398981755753`*^9, {3.941439936370954*^9, 
   3.941439985648348*^9}, 3.9414400595313473`*^9, 3.941440197550312*^9, 
   3.941440558841687*^9, 3.9414406251222253`*^9, 3.941440743960739*^9, 
   3.9414408444994392`*^9, {3.9414410282232256`*^9, 3.941441052612735*^9}, 
   3.9414411056175823`*^9, 3.941441255191676*^9, 3.941449188854942*^9, 
   3.9414496890268955`*^9, 3.9414499545957947`*^9, 3.9414501098768897`*^9, 
   3.9414508784652977`*^9, {3.9414510001068287`*^9, 3.9414510075741477`*^9}, 
   3.941451413425783*^9, 3.9414521067135663`*^9, 3.9414521714299855`*^9, 
   3.941452397247778*^9, 3.9414525033796263`*^9, 3.941452761680439*^9, 
   3.94145282250331*^9, 3.9414530920409184`*^9, 3.941453444140894*^9},
 CellLabel->
  "Out[3060]=",ExpressionUUID->"741106ce-b3ba-4be4-9b5e-3c2cfea260d6"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Abs", "[", "\[Sigma]11", "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"Abs", "[", "\[Sigma]12", "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"Abs", "[", "\[Sigma]13", "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"Abs", "[", "\[Sigma]22", "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"Abs", "[", "\[Sigma]23", "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"Abs", "[", "\[Sigma]33", "]"}], "2"]}]], "Output",
 CellChangeTimes->{
  3.9365800908722477`*^9, 3.9365801331381464`*^9, 3.9365801984287405`*^9, 
   3.9365803694318423`*^9, 3.936580599259467*^9, {3.9365808044283323`*^9, 
   3.93658083986444*^9}, {3.936580879816351*^9, 3.9365808901604004`*^9}, 
   3.936580964166052*^9, 3.936581304764086*^9, 3.936581373096663*^9, 
   3.9365814887653837`*^9, 3.936581546497142*^9, 3.9365816742864876`*^9, 
   3.9365817215673404`*^9, 3.936581905468855*^9, 3.936581962574057*^9, {
   3.9365820372735863`*^9, 3.93658205116216*^9}, 3.9365821581740108`*^9, 
   3.9365822751845694`*^9, 3.936582719126978*^9, {3.9365828389451804`*^9, 
   3.936582881263*^9}, 3.9365829228809147`*^9, 3.9365829849676285`*^9, 
   3.9365830160149937`*^9, 3.9413510787314863`*^9, {3.9414329801663885`*^9, 
   3.9414330022891855`*^9}, 3.941433091859641*^9, 3.9414331586398325`*^9, 
   3.941433247717605*^9, 3.941433537656366*^9, 3.941434296682457*^9, {
   3.9414345075454483`*^9, 3.941434536543383*^9}, 3.9414347267201343`*^9, {
   3.941434890216775*^9, 3.941434906663334*^9}, 3.9414349732619944`*^9, 
   3.9414378740955715`*^9, 3.941438161450822*^9, 3.9414393680538445`*^9, 
   3.9414394032783213`*^9, 3.9414398981755753`*^9, {3.941439936370954*^9, 
   3.941439985648348*^9}, 3.9414400595313473`*^9, 3.941440197550312*^9, 
   3.941440558841687*^9, 3.9414406251222253`*^9, 3.941440743960739*^9, 
   3.9414408444994392`*^9, {3.9414410282232256`*^9, 3.941441052612735*^9}, 
   3.9414411056175823`*^9, 3.941441255191676*^9, 3.941449188854942*^9, 
   3.9414496890268955`*^9, 3.9414499545957947`*^9, 3.9414501098768897`*^9, 
   3.9414508784652977`*^9, {3.9414510001068287`*^9, 3.9414510075741477`*^9}, 
   3.941451413425783*^9, 3.9414521067135663`*^9, 3.9414521714299855`*^9, 
   3.941452397247778*^9, 3.9414525033796263`*^9, 3.941452761680439*^9, 
   3.94145282250331*^9, 3.9414530920409184`*^9, 3.941453444147876*^9},
 CellLabel->
  "Out[3061]=",ExpressionUUID->"60988257-2af7-44d0-9e25-e84cec1ba5ac"]
}, Open  ]]
},
WindowSize->{1153.5, 735.75},
WindowMargins->{{-5.25, Automatic}, {Automatic, 0}},
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{LinterUIDockedCell`Private`notebook$$}, 
     GraphicsBox[{
       InsetBox[
        TemplateBox[{
          PaneBox[
           StyleBox[
           "\"Code Analysis\"", FontColor -> GrayLevel[0.4], FontFamily -> 
            "Source Sans Pro", FontWeight -> Plain, FontSize -> 13, 
            StripOnInput -> False], 
           BaselinePosition -> (Baseline -> Scaled[0.65])], 
          TemplateBox[{8}, "Spacer1"], 
          PaneBox[
           
           PaneSelectorBox[{{False, False} -> 
             TemplateBox[{0}, "Spacer1"], {True, False} -> 
             TemplateBox[{0}, "Spacer1"], {True, True} -> PaneBox[
               InterpretationBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "PercolateAnimator"][Medium]], 
                ProgressIndicator[Appearance -> "Percolate"], 
                BaseStyle -> {"Deploy"}], BaselinePosition -> Scaled[0.05]], {
              False, True} -> 
             DynamicModuleBox[{
               CodeInspector`LinterUI`Private`tracker$$ = 
                CodeInspector`LinterUI`Private`DynamicTriggers`\
dockedCellLintCounts}, 
               DynamicWrapperBox[
                DynamicBox[
                 ToBoxes[
                 CodeInspector`LinterUI`Private`tracker$$; 
                  LinterUIDockedCell`Private`dockedCellSeverityCountsButton[
                   LinterUIDockedCell`Private`notebook$$], TraditionalForm], 
                 TrackedSymbols :> {
                  CodeInspector`LinterUI`Private`tracker$$}], 
                If[
                CodeInspector`LinterUI`Private`tracker$$ =!= 
                 CodeInspector`LinterUI`Private`DynamicTriggers`\
dockedCellLintCounts, CodeInspector`LinterUI`Private`tracker$$ = 
                 CodeInspector`LinterUI`Private`DynamicTriggers`\
dockedCellLintCounts]], DynamicModuleValues :> {}]}, 
            Dynamic[FEPrivate`EvaluatorStatus["Local"]; {
               CodeInspector`LinterUI`Private`varValue[
               LinterUIDockedCell`Private`notebook$$, "AnalysisInProgressQ"], 
               TrueQ[
                CodeInspector`LinterUI`Private`varValue[
                LinterUIDockedCell`Private`notebook$$, 
                 "DockedCellPresentQ"]]}], ImageSize -> Automatic], 
           BaselinePosition -> Scaled[0.15]]}, "Row", 
         DisplayFunction -> (PaneBox[
           RowBox[{
             TemplateSlotSequence[1, "\[InvisibleSpace]"]}], Alignment -> 
           Baseline]& ), InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                TemplateSlotSequence[1, ","], "}"}], ",", 
              RowBox[{"Alignment", "\[Rule]", "Baseline"}]}], "]"}]& )], 
        Offset[{8, 0}, {-1, 0}], {-1, 0}], 
       InsetBox[
        PaneSelectorBox[{
         True -> DynamicModuleBox[{
            CodeInspector`LinterUI`Private`hoverQ$$ = False, 
             CodeInspector`LinterUI`Private`mouseDownQ$$ = False, 
             CodeInspector`LinterUI`Private`fontColor$$}, 
            ButtonBox[
             DynamicWrapperBox[
              TemplateBox[{
                DynamicWrapperBox[
                 StyleBox[
                  PaneBox[
                  "\"Reanalyze Notebook\"", ContentPadding -> True, 
                   FrameMargins -> None, BaselinePosition -> Baseline], 
                  FontColor -> 
                  Dynamic[CodeInspector`LinterUI`Private`fontColor$$], 
                  FontColor -> GrayLevel[0.2], FontFamily -> 
                  "Source Sans Pro", FontWeight -> Plain, FontSize -> 14, 
                  StripOnInput -> False], 
                 CodeInspector`LinterUI`Private`fontColor$$ = Which[
                   TrueQ[
                    Not[
                    
                    OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "ActiveQ"]]], 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "TextInactiveColor"], 
                   CodeInspector`LinterUI`Private`hoverQ$$, 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "TextHoverColor"], True, 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "TextColor"]]], ContentPadding -> False, 
                FrameMargins -> {{9, 9}, {0, 0}}, 
                Alignment -> {Center, Center}, ImageSize -> {Automatic, 19}, 
                RoundingRadius -> 3, FrameStyle -> Dynamic[
                  Directive[
                   AbsoluteThickness[0.5], 
                   Which[
                    TrueQ[
                    Not[
                    
                    OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "ActiveQ"]]], 
                    
                    OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "EdgeInactiveColor"], 
                    CodeInspector`LinterUI`Private`hoverQ$$, 
                    
                    OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "EdgeHoverColor"], True, 
                    
                    OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "EdgeColor"]]]], Background -> Dynamic[
                  Which[
                   TrueQ[
                    Not[
                    
                    OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "ActiveQ"]]], 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "BackInactiveColor"], 
                   And[
                   CodeInspector`LinterUI`Private`hoverQ$$, 
                    CodeInspector`LinterUI`Private`mouseDownQ$$], 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "BackMouseDownColor"], 
                   CodeInspector`LinterUI`Private`hoverQ$$, 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "BackHoverColor"], True, 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "BackColor"]]]}, "Highlighted"], 
              CodeInspector`LinterUI`Private`hoverQ$$ = 
               CurrentValue["MouseOver"]; 
              CodeInspector`LinterUI`Private`mouseDownQ$$ = 
               CurrentValue["MouseButtonTest"]], 
             Appearance -> {
              "Default" -> 
               Image[RawArray["UnsignedInteger8",{{{255, 255, 255, 255}, {0, 
                  0, 0, 255}, {255, 255, 255, 255}}, {{0, 0, 0, 255}, {0, 0, 
                  0, 0}, {0, 0, 0, 255}}, {{255, 255, 255, 255}, {0, 0, 0, 
                  255}, {255, 255, 255, 255}}}], "Byte", ColorSpace -> "RGB", 
                 ImageResolution -> {72, 72}, Interleaving -> True], "Hover" -> 
               Image[RawArray["UnsignedInteger8",{{{255, 255, 255, 255}, {0, 
                  0, 0, 255}, {255, 255, 255, 255}}, {{0, 0, 0, 255}, {0, 0, 
                  0, 0}, {0, 0, 0, 255}}, {{255, 255, 255, 255}, {0, 0, 0, 
                  255}, {255, 255, 255, 255}}}], "Byte", ColorSpace -> "RGB", 
                 ImageResolution -> {72, 72}, Interleaving -> True], 
               "Pressed" -> 
               Image[RawArray["UnsignedInteger8",{{{255, 255, 255, 255}, {0, 
                  0, 0, 255}, {255, 255, 255, 255}}, {{0, 0, 0, 255}, {0, 0, 
                  0, 0}, {0, 0, 0, 255}}, {{255, 255, 255, 255}, {0, 0, 0, 
                  255}, {255, 255, 255, 255}}}], "Byte", ColorSpace -> "RGB", 
                 ImageResolution -> {72, 72}, Interleaving -> True]}, 
             BaselinePosition -> Baseline, 
             ButtonFunction :> (
              If[OptionValue[{
                  ImageSize -> {Automatic, 19}, 
                   FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                   Baseline, Alignment -> {Center, Center}, Method -> 
                   "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                   CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                   "TextHoverColor" -> 
                   CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                   CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                   CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                   "BackHoverColor" -> 
                   CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                   CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                   CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                   CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                   "EdgeHoverColor" -> 
                   CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                   CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, "ActiveQ"] =!= 
                False, 
                CodeInspector`LinterUI`Private`attachAnalysisAction[
                 EvaluationNotebook[]]]; 
              CodeInspector`LinterUI`Private`mouseDownQ$$ = False), 
             ContentPadding -> False, Evaluator -> Automatic, Method -> 
             "Queued"], DynamicModuleValues :> {}], False -> ButtonBox[
            TemplateBox[{
              StyleBox[
              "\"Analyze Notebook\"", FontColor -> GrayLevel[0.2], FontFamily -> 
               "Source Sans Pro", FontWeight -> Plain, FontSize -> 14, 
               StripOnInput -> False], ImageSize -> {Automatic, 19}, 
              FrameMargins -> {{9, 9}, {0, 0}}, BaselinePosition -> Baseline, 
              Alignment -> {Center, Center}, Background -> GrayLevel[1], 
              FrameStyle -> Dynamic[
                If[
                 CurrentValue["MouseOver"], 
                 Hue[0.55, 0.82, 0.87], 
                 GrayLevel[0.8]]]}, "Highlighted"], 
            Appearance -> {
             "Default" -> 
              Image[RawArray["UnsignedInteger8",{{{255, 255, 255, 255}, {0, 0,
                  0, 255}, {255, 255, 255, 255}}, {{0, 0, 0, 255}, {0, 0, 0, 
                 0}, {0, 0, 0, 255}}, {{255, 255, 255, 255}, {0, 0, 0, 255}, {
                 255, 255, 255, 255}}}], "Byte", ColorSpace -> "RGB", 
                ImageResolution -> {72, 72}, Interleaving -> True], "Hover" -> 
              Image[RawArray["UnsignedInteger8",{{{255, 255, 255, 255}, {0, 0,
                  0, 255}, {255, 255, 255, 255}}, {{0, 0, 0, 255}, {0, 0, 0, 
                 0}, {0, 0, 0, 255}}, {{255, 255, 255, 255}, {0, 0, 0, 255}, {
                 255, 255, 255, 255}}}], "Byte", ColorSpace -> "RGB", 
                ImageResolution -> {72, 72}, Interleaving -> True], "Pressed" -> 
              Image[RawArray["UnsignedInteger8",{{{255, 255, 255, 255}, {0, 0,
                  0, 255}, {255, 255, 255, 255}}, {{0, 0, 0, 255}, {0, 0, 0, 
                 0}, {0, 0, 0, 255}}, {{255, 255, 255, 255}, {0, 0, 0, 255}, {
                 255, 255, 255, 255}}}], "Byte", ColorSpace -> "RGB", 
                ImageResolution -> {72, 72}, Interleaving -> True]}, 
            ButtonFunction :> (CurrentValue[
                EvaluationNotebook[], DockedCells] = 
              With[{LinterUIDockedCell`Private`dockedCells = CurrentValue[
                   EvaluationNotebook[], DockedCells]}, 
                Pick[LinterUIDockedCell`Private`dockedCells, 
                 Map[Quiet[
                    Options[#, CellTags]] =!= {
                   CellTags -> "CodeAnalysisDockedCell"}& , 
                  LinterUIDockedCell`Private`dockedCells]]]; 
             Needs["CodeInspector`"]; 
             CodeInspector`AttachAnalysis[
              LinterUIDockedCell`Private`notebook$$]), Evaluator -> Automatic,
             Method -> "Queued"]}, 
         Dynamic[FEPrivate`EvaluatorStatus["Local"]; TrueQ[
            CodeInspector`LinterUI`Private`varValue[
            LinterUIDockedCell`Private`notebook$$, "DockedCellPresentQ"]]], 
         ImageSize -> Automatic], 
        Offset[{-26, 0}, {1, 0}], {1, 0}], 
       TagBox[
        TagBox[
         TooltipBox[{{
            GrayLevel[0.6], 
            DiskBox[
             Offset[{-11, 0}, {1, 0}], 
             Offset[6]]}, {
            GrayLevel[0.97], 
            AbsoluteThickness[1.5], 
            CapForm["Round"], 
            LineBox[{{
               Offset[{-13, 2}, {1, 0}], 
               Offset[{-9, -2}, {1, 0}]}, {
               Offset[{-13, -2}, {1, 0}], 
               Offset[{-9, 2}, {1, 0}]}}]}}, "\"Close analysis\"", 
          TooltipDelay -> 0, TooltipStyle -> "TextStyling"], 
         Annotation[#, "Close analysis", "Tooltip"]& ], 
        EventHandlerTag[{"MouseClicked" :> (Map[NotebookDelete, 
             Flatten[
              CodeInspector`LinterUI`Private`varValue[
              LinterUIDockedCell`Private`notebook$$, All, 
               "UIAttachedCells"]]]; Map[NotebookDelete, 
             Flatten[
              CodeInspector`LinterUI`Private`varValue[
              LinterUIDockedCell`Private`notebook$$, All, 
               "CleanCellBracketMarker"]]]; CurrentValue[
              EvaluationNotebook[], DockedCells] = 
            With[{LinterUIDockedCell`Private`dockedCells = CurrentValue[
                 EvaluationNotebook[], DockedCells]}, 
              Pick[LinterUIDockedCell`Private`dockedCells, 
               Map[Quiet[
                  Options[#, CellTags]] =!= {
                 CellTags -> "CodeAnalysisDockedCell"}& , 
                LinterUIDockedCell`Private`dockedCells]]]; 
           CodeInspector`LinterUI`Private`applyToVar[Remove, {
              EvaluationNotebook[], All}]; 
           CodeInspector`LinterUI`Private`varSet[{
             LinterUIDockedCell`Private`notebook$$, "DockedCellPresentQ"}, 
             False]), Method -> "Preemptive", PassEventsDown -> Automatic, 
          PassEventsUp -> True}]]}, AspectRatio -> Full, 
      ImageSize -> {Full, 23}, PlotRange -> {{-1, 1}, {-1, 1}}], 
     Deinitialization :> 
     CodeInspector`LinterUI`Private`varSet[{
       LinterUIDockedCell`Private`notebook$$, "DockedCellPresentQ"}, False], 
     DynamicModuleValues :> {}, 
     Initialization :> ({
       LinterUIDockedCell`Private`dockedCellSeverityCountsButton[
          Pattern[LinterUIDockedCell`Private`notebook, 
           Blank[NotebookObject]]] := 
        With[{LinterUIDockedCell`Private`formatIcon = 
           Show[#, ImageSize -> {13, 9}, BaselinePosition -> Scaled[-0.2]]& }, 
          ActionMenu[
           Highlighted[
            Row[{
              CodeInspector`LinterUI`Private`lintSeverityCountsIconRow[
              LinterUIDockedCell`Private`notebook, "exclamSize" -> 12, 
               FontSize -> 14, FontWeight -> Plain], 
              Spacer[2], 
              LinterUIDockedCell`Private`formatIcon[
               CodeInspector`LinterUI`Private`iconData["DownChevron"][
                CodeInspector`LinterUI`Private`colorData["UIDark"]]]}], 
            ImageSize -> {Automatic, 19}, BaselinePosition -> Baseline, 
            Background -> White, Frame -> True, FrameStyle -> Dynamic[
              If[
               CurrentValue["MouseOver"], 
               Hue[0.55, 0.82, 0.87], 
               GrayLevel[0.8]]], FrameMargins -> {6 {1, 1}, {1, 1}}, 
            Alignment -> {Center, Baseline}], 
           Map[
           LinterUIDockedCell`Private`dockedCellMenuItem[
            LinterUIDockedCell`Private`notebook, #]& , 
            CodeInspector`LinterUI`Private`varValue[
            LinterUIDockedCell`Private`notebook, All, "Cell"]], Appearance -> 
           None]], LinterUIDockedCell`Private`dockedCellMenuItem[
          Pattern[LinterUIDockedCell`Private`notebook, 
           Blank[NotebookObject]], 
          Pattern[LinterUIDockedCell`Private`cell, 
           Blank[CellObject]]] := With[{}, Graphics[{
             Inset[
              With[{LinterUIDockedCell`Private`expressionString = First[
                  FrontEndExecute[
                   FrontEnd`ExportPacket[
                    First[
                    CodeInspector`LinterUI`Private`varValue[
                    LinterUIDockedCell`Private`notebook, 
                    LinterUIDockedCell`Private`cell, "CellContents"]], 
                    "InputText"]]]}, {
               LinterUIDockedCell`Private`noLineBreaks = 
                StringReplace[
                 LinterUIDockedCell`Private`expressionString, "\n" -> " "]}, {
               LinterUIDockedCell`Private`previewString = 
                StringTake[LinterUIDockedCell`Private`noLineBreaks, {1, 
                   UpTo[LinterUIDockedCell`Private`$previewLength]}]}, 
               CodeInspector`LinterUI`Private`styleData["FixedWidth"][
                If[
                StringLength[LinterUIDockedCell`Private`expressionString] > 
                 LinterUIDockedCell`Private`$previewLength, 
                 StringDrop[LinterUIDockedCell`Private`previewString, -1] <> 
                 "\[Ellipsis]", 
                 LinterUIDockedCell`Private`previewString]]], {-1, 0}, {-1, 
              0}], 
             Inset[
              CodeInspector`LinterUI`Private`lintSeverityCountsIconRow[
              LinterUIDockedCell`Private`cell], {1, 0}, {1, 0}]}, 
            ImageSize -> {300, 25}, AspectRatio -> Full, 
            PlotRange -> {{-1, 1}, {-1, 1}}, ImagePadding -> None] :> (
           SelectionMove[LinterUIDockedCell`Private`cell, All, Cell]; 
           With[{LinterUIDockedCell`Private`nb = 
              ParentNotebook[LinterUIDockedCell`Private`cell]}, 
             FrontEndExecute[
              FrontEnd`FrontEndToken[
              LinterUIDockedCell`Private`nb, "OpenSelectionParents"]]]; 
           SelectionMove[LinterUIDockedCell`Private`cell, After, Cell])], 
        LinterUIDockedCell`Private`$previewLength = 28, 
        CodeInspector`LinterUI`Private`applyToVar[
          Pattern[CodeInspector`LinterUI`Private`function, 
           Blank[]], {
           Pattern[CodeInspector`LinterUI`Private`notebook, 
            Blank[NotebookObject]], All, 
           Pattern[CodeInspector`LinterUI`Private`name, 
            Blank[String]]}, 
          Pattern[CodeInspector`LinterUI`Private`args, 
           BlankNullSequence[]]] := 
        Map[Apply[CodeInspector`LinterUI`Private`function, 
           Join[
            ToHeldExpression[#], 
            Hold[CodeInspector`LinterUI`Private`args]]]& , 
          
          Names[(CodeInspector`LinterUI`Private`varNameString[
             CodeInspector`LinterUI`Private`notebook] <> "*") <> 
           CodeInspector`LinterUI`Private`name]], Null, 
        CodeInspector`LinterUI`Private`applyToVar[
          Pattern[CodeInspector`LinterUI`Private`function, 
           Blank[]], {
           Pattern[CodeInspector`LinterUI`Private`nameArguments, 
            BlankSequence[]], 
           Pattern[CodeInspector`LinterUI`Private`name, 
            Blank[String]]}, 
          Pattern[CodeInspector`LinterUI`Private`args, 
           BlankNullSequence[]]] := 
        Apply[CodeInspector`LinterUI`Private`function, 
          Join[
           ToHeldExpression[
            CodeInspector`LinterUI`Private`varNameString[
            CodeInspector`LinterUI`Private`nameArguments]], 
           Hold[CodeInspector`LinterUI`Private`args]]], Null, 
        CodeInspector`LinterUI`Private`applyToVar[
          Pattern[CodeInspector`LinterUI`Private`function, 
           Blank[]], {
           Pattern[CodeInspector`LinterUI`Private`nameArguments, 
            BlankSequence[]], All}, 
          Pattern[CodeInspector`LinterUI`Private`args, 
           BlankNullSequence[]]] := 
        Map[Apply[CodeInspector`LinterUI`Private`function, 
           Join[
            ToHeldExpression[#], 
            Hold[CodeInspector`LinterUI`Private`args]]]& , 
          Names[
          CodeInspector`LinterUI`Private`varNameString[
            CodeInspector`LinterUI`Private`nameArguments] <> "*"]], 
        CodeInspector`LinterUI`Private`varValue[
          Pattern[CodeInspector`LinterUI`Private`notebook, 
           Blank[NotebookObject]], All, 
          Pattern[CodeInspector`LinterUI`Private`name, 
           Blank[String]]] := Map[Symbol, 
          
          Names[(CodeInspector`LinterUI`Private`varNameString[
             CodeInspector`LinterUI`Private`notebook] <> "*") <> 
           CodeInspector`LinterUI`Private`name]], Null, 
        CodeInspector`LinterUI`Private`varValue[
          Pattern[CodeInspector`LinterUI`Private`nameArguments, 
           BlankSequence[]], 
          Pattern[CodeInspector`LinterUI`Private`name, 
           Blank[String]]] := Symbol[
          CodeInspector`LinterUI`Private`varNameString[
          CodeInspector`LinterUI`Private`nameArguments, 
           CodeInspector`LinterUI`Private`name]], Null, 
        CodeInspector`LinterUI`Private`varValue[
          Pattern[CodeInspector`LinterUI`Private`nameArguments, 
           BlankSequence[]], All] := Map[Symbol, 
          Names[
          CodeInspector`LinterUI`Private`varNameString[
            CodeInspector`LinterUI`Private`nameArguments] <> "*"]], 
        CodeInspector`LinterUI`Private`varSet[{
           Pattern[CodeInspector`LinterUI`Private`nameArguments, 
            BlankSequence[]]}, 
          Pattern[CodeInspector`LinterUI`Private`value, 
           Blank[]]] := Apply[Set, 
          Append[
           ToHeldExpression[
            CodeInspector`LinterUI`Private`varNameString[
            CodeInspector`LinterUI`Private`nameArguments]], 
           CodeInspector`LinterUI`Private`value]], 
        CodeInspector`LinterUI`Private`varNameString[
          Pattern[CodeInspector`LinterUI`Private`notebook, 
           Blank[NotebookObject]]] := ((
           "CodeInspector`LinterUI`Private`Vars`" <> "$$") <> 
          With[{CodeInspector`LinterUI`Private`nbID = 
             Last[CodeInspector`LinterUI`Private`notebook]}, 
            If[
             StringQ[CodeInspector`LinterUI`Private`nbID], 
             StringReplace[CodeInspector`LinterUI`Private`nbID, "-" -> "$"], 
             ToString[CodeInspector`LinterUI`Private`nbID]]]) <> "$$", Null, 
        CodeInspector`LinterUI`Private`varNameString[
          Pattern[CodeInspector`LinterUI`Private`cell, 
           Blank[CellObject]]] := (
          CodeInspector`LinterUI`Private`varNameString[
            Replace[
             ParentNotebook[CodeInspector`LinterUI`Private`cell], $Failed -> 
             EvaluationNotebook[]]] <> 
          With[{CodeInspector`LinterUI`Private`cellID = 
             First[CodeInspector`LinterUI`Private`cell]}, 
            If[
             StringQ[CodeInspector`LinterUI`Private`cellID], 
             StringReplace[CodeInspector`LinterUI`Private`cellID, "-" -> "$"], 
             ToString[CodeInspector`LinterUI`Private`cellID]]]) <> "$$", Null,
         CodeInspector`LinterUI`Private`varNameString[
          Pattern[CodeInspector`LinterUI`Private`notebook, 
           Blank[NotebookObject]], 
          Pattern[CodeInspector`LinterUI`Private`cell, 
           Blank[CellObject]]] := (
          CodeInspector`LinterUI`Private`varNameString[
           CodeInspector`LinterUI`Private`notebook] <> 
          With[{CodeInspector`LinterUI`Private`cellID = 
             First[CodeInspector`LinterUI`Private`cell]}, 
            If[
             StringQ[CodeInspector`LinterUI`Private`cellID], 
             StringReplace[CodeInspector`LinterUI`Private`cellID, "-" -> "$"], 
             ToString[CodeInspector`LinterUI`Private`cellID]]]) <> "$$", Null,
         CodeInspector`LinterUI`Private`varNameString[
          Pattern[CodeInspector`LinterUI`Private`notebook, 
           Blank[NotebookObject]], 
          Pattern[CodeInspector`LinterUI`Private`name, 
           Blank[String]]] := 
        CodeInspector`LinterUI`Private`varNameString[
          CodeInspector`LinterUI`Private`notebook] <> 
         CodeInspector`LinterUI`Private`name, Null, 
        CodeInspector`LinterUI`Private`varNameString[
          Pattern[CodeInspector`LinterUI`Private`cell, 
           Blank[CellObject]], 
          Pattern[CodeInspector`LinterUI`Private`name, 
           Blank[String]]] := 
        CodeInspector`LinterUI`Private`varNameString[
          CodeInspector`LinterUI`Private`cell] <> 
         CodeInspector`LinterUI`Private`name, Null, 
        CodeInspector`LinterUI`Private`varNameString[
          Pattern[CodeInspector`LinterUI`Private`notebook, 
           Blank[NotebookObject]], 
          Pattern[CodeInspector`LinterUI`Private`cell, 
           Blank[CellObject]], 
          Pattern[CodeInspector`LinterUI`Private`name, 
           Blank[String]]] := 
        CodeInspector`LinterUI`Private`varNameString[
          CodeInspector`LinterUI`Private`notebook, 
           CodeInspector`LinterUI`Private`cell] <> 
         CodeInspector`LinterUI`Private`name, Null, 
        CodeInspector`LinterUI`Private`varNameString[
          Pattern[CodeInspector`LinterUI`Private`nameArguments, 
           BlankSequence[]], 
          Pattern[CodeInspector`LinterUI`Private`lint, 
           Blank[CodeInspector`InspectionObject]], 
          Pattern[CodeInspector`LinterUI`Private`name, 
           Blank[String]]] := ((
           CodeInspector`LinterUI`Private`varNameString[
            CodeInspector`LinterUI`Private`nameArguments] <> Apply[Sequence, 
             Riffle[
              Map[StringDelete[
                ToString[#], 
                Alternatives["[", "]", "{", "}", ",", " "]]& , 
               CodeInspector`LinterUI`Private`extractFirstList[
                Last[CodeInspector`LinterUI`Private`lint][
                CodeParser`Source]]], "$"]]) <> "$$") <> 
         CodeInspector`LinterUI`Private`name, 
        CodeInspector`LinterUI`Private`extractFirstList[
          Pattern[CodeInspector`LinterUI`Private`expr, 
           Blank[]]] := FirstCase[CodeInspector`LinterUI`Private`expr, 
          Blank[List], {}, {0, Infinity}]}; 
      LinterUIDockedCell`Private`notebook$$ = EvaluationNotebook[]), 
     UnsavedVariables :> {LinterUIDockedCell`Private`notebook$$}]], 
   CellFrame -> {{0, 0}, {1, 1}}, CellFrameMargins -> {{0, 0}, {0, 0}}, 
   CellFrameColor -> GrayLevel[0.85], Background -> GrayLevel[0.97], CellTags -> 
   "CodeAnalysisDockedCell"]},
FrontEndVersion->"13.1 for Microsoft Windows (64-bit) (June 16, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"56dac2ba-3491-451c-a6ec-6b2f304b3642"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1179, 27, 83, "Input",ExpressionUUID->"c220cb0e-a916-48ce-a81c-0205de56f38c"],
Cell[CellGroupData[{
Cell[1762, 51, 5887, 154, 739, "Input",ExpressionUUID->"3f3f6604-c04a-4043-b945-d6f8f4d99e53"],
Cell[7652, 207, 5074, 79, 131, "Output",ExpressionUUID->"0ccdd3b3-57b0-4718-bc86-c8cb549455e4"],
Cell[12729, 288, 4417, 64, 46, "Output",ExpressionUUID->"95db776d-5f7f-4a69-8656-713726ba7581"]
}, Open  ]],
Cell[17161, 355, 661, 17, 28, "Input",ExpressionUUID->"86acad93-7342-4ded-b093-b5264b074c2f"],
Cell[CellGroupData[{
Cell[17847, 376, 6062, 163, 739, "Input",ExpressionUUID->"90a9901a-e691-4da1-ae7b-2b7fd8655dba"],
Cell[23912, 541, 2184, 40, 131, "Output",ExpressionUUID->"b6811655-a4ab-44bc-b190-616a0ef1d32f"],
Cell[26099, 583, 1523, 25, 46, "Output",ExpressionUUID->"43ab9b0c-373c-417b-865e-962b5e2211f9"]
}, Open  ]],
Cell[27637, 611, 669, 19, 28, "Input",ExpressionUUID->"9573ddf7-1386-43f0-aca7-5b2b1b7c4af3"],
Cell[CellGroupData[{
Cell[28331, 634, 5015, 155, 739, "Input",ExpressionUUID->"9605dcd7-3e19-4471-af22-63e821cb8e62"],
Cell[33349, 791, 1902, 38, 131, "Output",ExpressionUUID->"ade0421b-457f-4a41-8b80-9ad8bcfbe08d"],
Cell[35254, 831, 1093, 19, 46, "Output",ExpressionUUID->"01642206-1945-4735-85b1-20c2353be544"]
}, Open  ]],
Cell[36362, 853, 910, 21, 28, "Input",ExpressionUUID->"0008b473-448e-4877-9423-f6937d4c7ed1"],
Cell[CellGroupData[{
Cell[37297, 878, 11750, 320, 1214, "Input",ExpressionUUID->"258805fa-bd1e-4285-b19a-325d81a133f0"],
Cell[49050, 1200, 2593, 46, 131, "Output",ExpressionUUID->"473bb0ff-7da4-4199-8efd-77461d412e36"],
Cell[51646, 1248, 2005, 31, 46, "Output",ExpressionUUID->"ea7e746d-3fa3-4e35-95ad-2adef405f963"],
Cell[53654, 1281, 2690, 49, 131, "Output",ExpressionUUID->"ec881fd6-5cd3-4821-8740-18b28e58f68b"],
Cell[56347, 1332, 2021, 31, 32, "Output",ExpressionUUID->"b728cc8a-0634-4ff4-8cab-9e9189df526e"]
}, Open  ]],
Cell[58383, 1366, 836, 20, 28, "Input",ExpressionUUID->"2f5409e5-1a16-4e37-a439-7ca715810f68"],
Cell[CellGroupData[{
Cell[59244, 1390, 12899, 345, 1363, "Input",ExpressionUUID->"6a9acde0-b1bd-47e9-833a-9a054da93d9a"],
Cell[72146, 1737, 2477, 44, 131, "Output",ExpressionUUID->"59ecb003-cda4-4c94-8d1a-301a3cdee89c"],
Cell[74626, 1783, 1829, 29, 46, "Output",ExpressionUUID->"97049750-18cd-48b3-88f6-299307e8aff5"],
Cell[76458, 1814, 2629, 51, 131, "Output",ExpressionUUID->"1c689e8a-1340-4593-bb7d-98559d485e49"],
Cell[79090, 1867, 2549, 47, 131, "Output",ExpressionUUID->"dbb02388-8de5-414a-b4b6-3d074ba3da9a"],
Cell[81642, 1916, 1859, 29, 32, "Output",ExpressionUUID->"10f97ee0-5b67-4a98-9d9b-998a350b147b"]
}, Open  ]],
Cell[83516, 1948, 487, 11, 28, "Input",ExpressionUUID->"dc941b24-8577-4642-939d-d760334be227"],
Cell[CellGroupData[{
Cell[84028, 1963, 5689, 147, 785, "Input",ExpressionUUID->"2cb1e926-5f49-427c-b71c-0e9592bc0736"],
Cell[89720, 2112, 2205, 42, 79, "Output",ExpressionUUID->"6cac9703-a283-4ed2-8db3-8e48ed764f7c"],
Cell[91928, 2156, 1721, 26, 46, "Output",ExpressionUUID->"3208674f-aca5-45fd-b2c6-dac73646e73d"],
Cell[93652, 2184, 2232, 43, 79, "Output",ExpressionUUID->"95a08529-e2a0-476c-9892-f294df4b884d"],
Cell[95887, 2229, 2278, 44, 79, "Output",ExpressionUUID->"632bd8fb-0186-41ff-845b-275d00956d0f"],
Cell[98168, 2275, 1742, 27, 32, "Output",ExpressionUUID->"9e0a03e9-4c0b-42e6-bf11-f0c1d2c976f0"]
}, Open  ]],
Cell[99925, 2305, 482, 11, 28, "Input",ExpressionUUID->"1d896bb4-d160-441a-8d59-d28885efc9e4"],
Cell[CellGroupData[{
Cell[100432, 2320, 6110, 152, 785, "Input",ExpressionUUID->"d2a4bf2e-780c-471a-9f5b-2813553ebf14"],
Cell[106545, 2474, 2131, 41, 79, "Output",ExpressionUUID->"730a5702-8fd5-4ada-bf52-983f59f50e00"],
Cell[108679, 2517, 1624, 26, 46, "Output",ExpressionUUID->"4b774876-1aec-4728-be6e-4f929079d482"],
Cell[110306, 2545, 2171, 42, 79, "Output",ExpressionUUID->"446a6969-fce4-4b80-ae0d-2c104e93ba32"],
Cell[112480, 2589, 2153, 41, 79, "Output",ExpressionUUID->"c5c02032-4420-4c12-905c-f2dfb5766000"],
Cell[114636, 2632, 1644, 25, 32, "Output",ExpressionUUID->"cc8fca87-7907-4374-b567-53b7282c0b7f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116317, 2662, 3842, 83, 419, "Input",ExpressionUUID->"fad05642-9298-4d10-ae13-aafb91a017ec"],
Cell[120162, 2747, 2562, 45, 79, "Output",ExpressionUUID->"9eb70599-f73b-4a81-8ab6-382f3ffc7ee9"],
Cell[122727, 2794, 2731, 56, 140, "Output",ExpressionUUID->"7ba1360e-e12c-4733-a5d2-579eb2392102"],
Cell[125461, 2852, 2595, 50, 131, "Output",ExpressionUUID->"277592ce-2440-400e-ab54-b6bc4f1bdc8f"],
Cell[128059, 2904, 2500, 44, 46, "Output",ExpressionUUID->"5a8d7d0d-495f-45c6-803b-81c3f1bd563b"],
Cell[130562, 2950, 2500, 44, 46, "Output",ExpressionUUID->"741106ce-b3ba-4be4-9b5e-3c2cfea260d6"],
Cell[133065, 2996, 2425, 41, 46, "Output",ExpressionUUID->"60988257-2af7-44d0-9e25-e84cec1ba5ac"]
}, Open  ]]
}
]
*)

